/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.change;

import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.method.pdf.signature.SignatureFactoryETSIRFC3161;

public class FormChangeType {
    public static String TYPE_SIGNATURE = "signature";
    public static String TYPE_TIMESTAMP = "timestamp";
    public static String TYPE_TEXT = "text";
    public static String TYPE_COMBO = "combo";
    public static String TYPE_LIST = "list";
    public static String TYPE_RADIO = "radio";
    public static String TYPE_CHECK = "check";
    public static String TYPE_BUTTON = "button";

    public static String of(PDAcroFormField field) {
        if (field == null) {
            return null;
        }
        if (field.isTypeBtn()) {
            if (field.getFieldFlags().isPushbutton()) {
                return TYPE_BUTTON;
            }
            if (field.getFieldFlags().isRadio()) {
                return TYPE_RADIO;
            }
            return TYPE_CHECK;
        }
        if (field.isTypeCh()) {
            if (field.getFieldFlags().isCombo()) {
                return TYPE_COMBO;
            }
            return TYPE_LIST;
        }
        if (field.isTypeSig()) {
            PDAFSignatureField sigField = (PDAFSignatureField)field;
            PDSignature signature = sigField.getSignature();
            if (signature != null && SignatureFactoryETSIRFC3161.CN_ETSI_RFC3161.equals((Object)signature.getSubFilter())) {
                return TYPE_TIMESTAMP;
            }
            return TYPE_SIGNATURE;
        }
        if (field.isTypeTx()) {
            return TYPE_TEXT;
        }
        return null;
    }
}

