/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences.common;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.preferences.common.ILocatorPreferencesPersistence;
import de.intarsys.tools.preferences.common.LocatorPreferencesImpl;
import de.intarsys.tools.preferences.common.PreferencesHandler;
import de.intarsys.tools.preferences.common.PreferencesSerializer;
import de.intarsys.tools.sax.SAXTools;
import de.intarsys.tools.serialize.SerializationContext;
import de.intarsys.tools.serialize.xml.XMLSerializationContext;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import javax.xml.parsers.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPreferencesPersistence
implements ILocatorPreferencesPersistence {
    private static SAXParser Parser;
    private static PreferencesHandler Handler;
    private static final Object LOCK;
    private static final Logger Log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLPreferencesPersistence() {
        try {
            Object object = LOCK;
            synchronized (object) {
                if (Parser == null) {
                    Parser = SAXTools.createSecureParserFactory().newSAXParser();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't create SAXParser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadPreferences(LocatorPreferencesImpl root, ILocator locator) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            InputStream is = null;
            try {
                is = locator.getInputStream();
                Handler.reset();
                Handler.setPreferences(root);
                Parser.parse(is, (DefaultHandler)((Object)Handler));
            }
            catch (SAXException e) {
                throw new IOException("XML format exception", e);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("unexpected exception", e);
            }
            finally {
                StreamTools.close((Closeable)is);
            }
            root.setLocator(locator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePreferences(LocatorPreferencesImpl root, ILocator locator) throws IOException {
        if (root == null) {
            return;
        }
        if (!root.isChanged()) {
            return;
        }
        File tempFile = FileTools.createTempFile((String)locator.getName());
        tempFile.deleteOnExit();
        FileLocator tempLocator = new FileLocator(tempFile);
        try {
            OutputStream os = null;
            try {
                os = tempLocator.getOutputStream();
                XMLSerializationContext context = new XMLSerializationContext(os, false);
                PreferencesSerializer serializer = new PreferencesSerializer((SerializationContext)context);
                serializer.serialize(root);
            }
            finally {
                StreamTools.close((Closeable)os);
            }
            LocatorTools.copy((ILocator)tempLocator, (ILocator)locator);
            root.setLocator(locator);
        }
        finally {
            try {
                Files.delete(tempFile.toPath());
            }
            catch (IOException e) {
                Log.warn("failed to delete temp file {}", (Object)tempFile);
            }
        }
    }

    static {
        Handler = new PreferencesHandler();
        LOCK = new Object();
        Log = LoggerFactory.getLogger(XMLPreferencesPersistence.class);
    }
}

