/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences.common;

import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesFactory;
import de.intarsys.tools.preferences.PreferencesAdapter;
import de.intarsys.tools.preferences.common.RootLocatorPreferencesImpl;
import java.io.File;
import java.util.prefs.Preferences;

public class RootLocatorPreferencesFactory
implements IPreferencesFactory {
    private IPreferences root;
    private IPreferences main;
    private ILocator rootLocator;

    public RootLocatorPreferencesFactory() {
    }

    public RootLocatorPreferencesFactory(ILocator rootLocator) {
        this.rootLocator = rootLocator;
    }

    protected ILocator createRootLocator() {
        File dir = FileEnvironment.get().getDataDir();
        File prefDir = new File(dir, "preferences");
        FileLocator locator = new FileLocator(prefDir);
        return locator;
    }

    public synchronized IPreferences getMain() {
        if (this.main == null) {
            this.main = this.getRoot().node("_default");
        }
        return this.main;
    }

    public synchronized IPreferences getRoot() {
        if (this.root == null) {
            RootLocatorPreferencesImpl rootJPrefs = new RootLocatorPreferencesImpl(null, "");
            rootJPrefs.setRootLocator(this.getRootLocator());
            this.root = new PreferencesAdapter(null, (Preferences)rootJPrefs);
        }
        return this.root;
    }

    public ILocator getRootLocator() {
        if (this.rootLocator == null) {
            this.rootLocator = this.createRootLocator();
        }
        return this.rootLocator;
    }

    public synchronized void setMain(IPreferences preferences) {
        this.main = preferences;
    }

    public void setRootLocator(ILocator rootLocator) {
        this.rootLocator = rootLocator;
    }
}

