/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authorization.acl;

import de.intarsys.aaa.authenticate.api.AuthenticationProvider;
import de.intarsys.aaa.authenticate.api.IAuthentication;
import de.intarsys.aaa.authenticate.api.IAuthority;
import de.intarsys.aaa.authorization.acl.AccessControlEntry;
import de.intarsys.aaa.authorization.acl.AccessControlList;
import de.intarsys.aaa.authorization.acl.IAclManager;
import de.intarsys.aaa.authorization.api.AccessDenied;
import de.intarsys.aaa.authorization.api.AuthorizationException;
import de.intarsys.aaa.authorization.impl.CommonAuthorizationStrategy;
import de.intarsys.aaa.resource.IOperation;
import de.intarsys.aaa.resource.IResource;
import de.intarsys.aaa.resource.SimpleObjectResource;
import de.intarsys.tools.lang.LangTools;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;

public class AclAuthorization
extends CommonAuthorizationStrategy {
    @Autowired
    private IAclManager aclManager;
    private boolean denyIfNotFound;

    public AclAuthorization() {
    }

    public AclAuthorization(IAclManager acm, boolean denyIfNotFound) {
        this.aclManager = acm;
        this.denyIfNotFound = denyIfNotFound;
    }

    protected AccessControlEntry findEntry(IResource resource, IOperation operation, IAuthentication authentication) {
        AccessControlEntry denial = null;
        AccessControlList acl = this.aclManager.getAccessControlList(resource);
        for (AccessControlEntry entry : acl.getEntries()) {
            if (!this.matchesOperation(entry, operation) || !this.matchesAuthorities(entry, authentication)) continue;
            if (entry.isGrant()) {
                return entry;
            }
            denial = entry;
        }
        return denial;
    }

    public IAclManager getAclManager() {
        return this.aclManager;
    }

    @Override
    protected void hookCheckAccess(IResource resource, IOperation operation) throws AuthorizationException {
        IAuthentication authentication = AuthenticationProvider.get().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new AccessDenied();
        }
        AccessControlEntry denial = null;
        AccessControlEntry entry = null;
        entry = this.findEntry(resource, operation, authentication);
        if (entry != null) {
            if (entry.isGrant()) {
                return;
            }
            denial = entry;
        }
        if ((entry = this.findEntry(SimpleObjectResource.createFromString(resource.getType(), "*"), operation, authentication)) != null) {
            if (entry.isGrant()) {
                return;
            }
            denial = entry;
        }
        if ((entry = this.findEntry(SimpleObjectResource.createFromString("*", "*"), operation, authentication)) != null) {
            if (entry.isGrant()) {
                return;
            }
            denial = entry;
        }
        if (denial != null) {
            throw new AccessDenied();
        }
        if (this.isDenyIfNotFound()) {
            throw new AccessDenied();
        }
    }

    public boolean isDenyIfNotFound() {
        return this.denyIfNotFound;
    }

    protected boolean matchesAuthorities(AccessControlEntry entry, IAuthentication authentication) {
        String[] tmpAuthorities;
        for (String tmpAuth : tmpAuthorities = entry.getAuthority().split("[,;]")) {
            if ("*".equals(tmpAuth = tmpAuth.trim())) {
                return true;
            }
            Collection<? extends IAuthority> authorities = authentication.getAuthorities();
            for (IAuthority iAuthority : authorities) {
                if (!LangTools.equals((Object)tmpAuth, (Object)iAuthority.getId())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean matchesOperation(AccessControlEntry entry, IOperation operation) {
        if (operation == null) {
            return entry.getOperation() == null;
        }
        return entry.getOperation().matches(operation);
    }

    public void setAclManager(IAclManager aclManager) {
        this.aclManager = aclManager;
    }

    public void setDenyIfNotFound(boolean denyIfNotFound) {
        this.denyIfNotFound = denyIfNotFound;
    }
}

