/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authenticate.module.composite;

import de.intarsys.aaa.authenticate.api.IAuthenticationContext;
import de.intarsys.aaa.authenticate.api.IAuthenticationModule;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationModule;
import de.intarsys.aaa.authenticate.module.composite.CompositeAuthenticationContext;
import de.intarsys.tools.collection.IterableTools;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;

public class CompositeAuthenticationModule
extends CommonAuthenticationModule {
    public static final String ARG_AUTHENTICATION_MODULES = "authenticationModules";
    private final List<IAuthenticationModule> moduleList = new ArrayList<IAuthenticationModule>();
    private IArgs args;

    public void addAuthenticationModule(IAuthenticationModule module) {
        this.moduleList.add(module);
    }

    public void addAuthenticationModule(InstanceSpec<IAuthenticationModule> authenticator) throws ObjectCreationException {
        IAuthenticationModule module = (IAuthenticationModule)authenticator.createInstance();
        this.addAuthenticationModule(module);
    }

    @Override
    public IAuthenticationContext createContext(Subject subject) {
        Subject mySubject = subject;
        if (subject == null) {
            mySubject = new Subject();
        }
        CompositeAuthenticationContext context = new CompositeAuthenticationContext(this, mySubject);
        for (IAuthenticationModule module : this.getModuleList()) {
            IAuthenticationContext childContext = module.createContext(mySubject);
            context.addAuthenticationContext(childContext);
        }
        return context;
    }

    @Override
    public IArgs getArgs() {
        return this.args;
    }

    public List<IAuthenticationModule> getModuleList() {
        return this.moduleList;
    }

    public void initFromArgs(IArgs args) throws ObjectCreationException {
        this.setArgs(args);
        IArgs authArgs = ArgTools.getArgs((IArgs)args, (String)ARG_AUTHENTICATION_MODULES, (IArgs)Args.create());
        for (IArgs.IBinding binding : IterableTools.in((Iterator)authArgs.bindings())) {
            Object moduleObject = binding.getValue();
            InstanceSpec moduleSpec = InstanceSpec.toInstanceSpec((Object)moduleObject, IAuthenticationModule.class);
            this.addAuthenticationModule((InstanceSpec<IAuthenticationModule>)moduleSpec);
        }
    }

    @Override
    public void setArgs(IArgs args) {
        this.args = args;
    }
}

