/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authenticate.impl;

import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.impl.NTCredential;
import de.intarsys.aaa.authenticate.impl.UserPasswordCredential;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.text.ParseException;

public class CredentialFactory
extends CommonInstantiatingFactory<ICredential> {
    protected ICredential basicCreateInstance(IArgs args) throws ObjectCreationException {
        IElement configuration = this.getConfiguration(args);
        if (configuration == null) {
            String userName;
            String qualifiedUserName = ArgTools.getString((IArgs)args, (String)"qualifiedUserName", null);
            String domain = null;
            if (qualifiedUserName != null) {
                try {
                    Object[] tokens = NTCredential.FORMAT_QUALIFIED_USERNAME.parse(qualifiedUserName);
                    domain = (String)tokens[0];
                    userName = (String)tokens[1];
                }
                catch (ParseException ex) {
                    userName = qualifiedUserName;
                }
            } else {
                userName = ArgTools.getString((IArgs)args, (String)"user", null);
            }
            if (StringTools.isEmpty((String)userName)) {
                throw new ObjectCreationException("user name must not be empty");
            }
            Secret password = ArgTools.getSecretHide((IArgs)args, (String)"password", (Secret)Secret.EMPTY);
            if (password == null) {
                throw new ObjectCreationException("password must not be null");
            }
            if (domain == null) {
                return new UserPasswordCredential(userName, password);
            }
            return new NTCredential(userName, password, domain);
        }
        String userName = configuration.attributeValue("user", null);
        Secret password = ElementTools.getSecretTemplate((IElement)configuration, (String)"password", null);
        String domain = configuration.attributeValue("domain", null);
        if (domain == null) {
            return new UserPasswordCredential(userName, password);
        }
        return new NTCredential(userName, password, domain);
    }

    public Class<ICredential> getResultType() {
        return ICredential.class;
    }
}

