/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ssl;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.ssl.ConfigurableKeyManagerProvider;
import de.intarsys.tools.ssl.IConfigurableSslContextProvider;
import de.intarsys.tools.ssl.ISslContextProvider;
import de.intarsys.tools.ssl.SslContextProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public final class SslTools {
    public static HostnameVerifier createHostnameVerifier(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String argString = (String)value;
            try {
                Class clazz = ClassTools.createClass((String)argString, HostnameVerifier.class, null);
                return (HostnameVerifier)ObjectTools.createObject((Class)clazz);
            }
            catch (ObjectCreationException e) {
                throw new IllegalArgumentException("Failed to create HostnameVerifier from " + value);
            }
        }
        if (value instanceof IArgs) {
            IArgs argArgs = (IArgs)value;
            try {
                InstanceSpec spec = InstanceSpec.createFromArgs(HostnameVerifier.class, (Object)argArgs);
                return (HostnameVerifier)spec.createInstance();
            }
            catch (ObjectCreationException e) {
                throw new IllegalArgumentException("Failed to create HostnameVerifier from " + value);
            }
        }
        throw new IllegalArgumentException("Failed to create HostnameVerifier from " + value);
    }

    public static SSLContext createSslContext(KeyStore keyStore, Secret password) throws GeneralSecurityException, IOException {
        IConfigurableSslContextProvider sslContextProvider = SslContextProvider.get().createProvider();
        ConfigurableKeyManagerProvider keyManagerProvider = new ConfigurableKeyManagerProvider();
        sslContextProvider.setKeyManagerProvider(keyManagerProvider);
        keyManagerProvider.setKeyStore(keyStore);
        keyManagerProvider.setKeyPassword(password);
        return sslContextProvider.createSslContext();
    }

    public static SSLContext createSslContext(Object value) throws GeneralSecurityException, IOException, ObjectCreationException {
        if (value == null) {
            return null;
        }
        if (value instanceof IArgs) {
            value = SslTools.createSslContextFromArgs((IArgs)value);
        }
        if (value instanceof SSLContext) {
            return (SSLContext)value;
        }
        if (value instanceof ISslContextProvider) {
            return ((ISslContextProvider)value).createSslContext();
        }
        try {
            SSLContext context = (SSLContext)ConverterRegistry.get().convert(value, SSLContext.class);
            if (context != null) {
                return context;
            }
        }
        catch (ConversionException context) {
            // empty catch block
        }
        try {
            ISslContextProvider provider = (ISslContextProvider)ConverterRegistry.get().convert(value, ISslContextProvider.class);
            if (provider != null) {
                return provider.createSslContext();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("Failed to create SSLContext from " + value);
    }

    public static SSLContext createSslContextDefault() throws GeneralSecurityException, IOException {
        return SslContextProvider.get().createSslContext();
    }

    private static Object createSslContextFromArgs(IArgs args) throws ObjectCreationException {
        return InstanceSpec.createFromArgs(Object.class, (Object)args).createInstance();
    }

    public static HostnameVerifier getHostnameVerifier(IArgs args, String path) {
        try {
            Object argValue = ArgTools.getObject((IArgs)args, (String)path, null);
            return SslTools.createHostnameVerifier(argValue);
        }
        catch (Exception e) {
            throw ExceptionTools.argumentInvalid((String)path, null, (Throwable)e);
        }
    }

    public static SSLContext getSslContext(IArgs args, String path) {
        Object value = ArgTools.getObject((IArgs)args, (String)path, null);
        try {
            return SslTools.createSslContext(value);
        }
        catch (Exception exception) {
            throw ExceptionTools.argumentInvalid((String)path, null, (Throwable)exception);
        }
    }

    public static SSLContext getSslContextOrDefault(IArgs args, String path) {
        Object value = ArgTools.getObject((IArgs)args, (String)path, null);
        try {
            SSLContext sslContext = SslTools.createSslContext(value);
            if (sslContext == null) {
                try {
                    sslContext = SslTools.createSslContextDefault();
                }
                catch (Exception e) {
                    throw ExceptionTools.argumentInvalid((String)"sslContext", (String)"default SSL context cannot be created", (Throwable)e);
                }
            }
            return sslContext;
        }
        catch (Exception exception) {
            throw ExceptionTools.argumentInvalid((String)path, null, (Throwable)exception);
        }
    }

    private SslTools() {
    }
}

