/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.egov.validationclient.cli;

import de.intarsys.aaa.authenticate.impl.UserPasswordCredential;
import de.intarsys.tools.crypto.Secret;
import picocli.CommandLine;

public class OptionProxy {
    private UserPasswordCredential credential;
    private String host;
    private int port;

    public OptionProxy(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public OptionProxy(String host, int port, UserPasswordCredential credential) {
        this(host, port);
        this.credential = credential;
    }

    public UserPasswordCredential getCredential() {
        return this.credential;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static class OptionProxyConverter
    implements CommandLine.ITypeConverter<OptionProxy> {
        public OptionProxy convert(String value) throws Exception {
            String[] tokens = value.split(":");
            if (tokens.length == 2 || tokens.length == 4) {
                String host = tokens[0];
                int port = Integer.valueOf(tokens[1]);
                if (tokens.length == 2) {
                    return new OptionProxy(host, port);
                }
                UserPasswordCredential credential = new UserPasswordCredential(tokens[2], Secret.hide((char[])tokens[3].toCharArray()));
                return new OptionProxy(tokens[0], port, credential);
            }
            throw new IllegalArgumentException();
        }
    }
}

