/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.common;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocumentOutlet;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.CreatedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.lang.Aliases;
import de.intarsys.tools.proxy.IProxy;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class StandardDocumentOutlet
implements IDocumentOutlet {
    private Map extensionsToType = new HashMap();
    private Map extensionsToName = new HashMap();
    private Map mimeTypesToType = new HashMap();
    private Map<String, IDocumentType> documentTypes = new HashMap<String, IDocumentType>();
    private EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private INotificationListener listenDocumentCreated = new INotificationListener(){

        public void handleEvent(Event event) {
            StandardDocumentOutlet.this.documentCreated(event);
        }
    };
    private final Function<IDocumentType, IDocumentType> fUnwrap = factory -> {
        if (factory instanceof IProxy) {
            return (IDocumentType)((IProxy)factory).getRealized();
        }
        return factory;
    };

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        StandardDocumentOutlet standardDocumentOutlet = this;
        synchronized (standardDocumentOutlet) {
            HashMap<String, IDocumentType> temp = new HashMap<String, IDocumentType>(this.documentTypes);
            for (String id : temp.keySet()) {
                this.unregisterDocumentType(id);
            }
        }
    }

    protected void documentCreated(Event event) {
        this.triggerEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocumentType[] getDocumentTypes() {
        StandardDocumentOutlet standardDocumentOutlet = this;
        synchronized (standardDocumentOutlet) {
            return (IDocumentType[])this.documentTypes.values().stream().map(this.fUnwrap).distinct().toArray(IDocumentType[]::new);
        }
    }

    public String[] getExtensionNames(IDocumentType type) {
        ArrayList result = new ArrayList();
        for (Map.Entry entry : this.extensionsToType.entrySet()) {
            IDocumentType tempType = (IDocumentType)entry.getValue();
            if (!tempType.getId().equals(type.getId())) continue;
            String key = (String)entry.getKey();
            result.add(this.extensionsToName.get(key));
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getExtensions(IDocumentType type) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : this.extensionsToType.entrySet()) {
            IDocumentType tempType = (IDocumentType)entry.getValue();
            if (!tempType.getId().equals(type.getId())) continue;
            String key = (String)entry.getKey();
            result.add(key);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getMimeTypes(IDocumentType type) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : this.mimeTypesToType.entrySet()) {
            IDocumentType tempType = (IDocumentType)entry.getValue();
            if (!tempType.getId().equals(type.getId())) continue;
            String key = (String)entry.getKey();
            result.add(key.trim());
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocumentType lookupDocumentType(String id) {
        StandardDocumentOutlet standardDocumentOutlet = this;
        synchronized (standardDocumentOutlet) {
            return this.fUnwrap.apply(this.documentTypes.get(Aliases.get().resolve(id)));
        }
    }

    public IDocumentType lookupDocumentTypeForExtension(String extension) {
        return (IDocumentType)this.extensionsToType.get(extension.toLowerCase());
    }

    public IDocumentType lookupDocumentTypeForMimeType(String mimeType) {
        if (StringTools.isEmpty((String)mimeType)) {
            return null;
        }
        return (IDocumentType)this.mimeTypesToType.get(mimeType.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDocumentType(String id, IDocumentType type) {
        StandardDocumentOutlet standardDocumentOutlet = this;
        synchronized (standardDocumentOutlet) {
            IDocumentType oldType = this.documentTypes.get(id);
            if (oldType != null) {
                throw new IllegalArgumentException("IDocumentType '" + id + "' already registered");
            }
            this.documentTypes.put(id, type);
            type.removeNotificationListener(CreatedEvent.ID, this.listenDocumentCreated);
            type.addNotificationListener(CreatedEvent.ID, this.listenDocumentCreated);
        }
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, (Object)"documentTypes", null, (Object)type);
        this.triggerEvent((Event)event);
    }

    public void registerExtension(String extension, IDocumentType type) {
        String extensionValue;
        String[] split = extension.split("\\|");
        String extensionLabel = extensionValue = split[0].trim().toLowerCase();
        if (split.length > 1) {
            extensionLabel = split[1].trim();
        }
        this.extensionsToType.put(extensionValue, type);
        this.extensionsToName.put(extensionValue, extensionLabel);
        DocumentTools.registerExtension(extensionValue, extensionLabel);
    }

    public void registerMimeType(String mimeType, IDocumentType type) {
        if (StringTools.isEmpty((String)mimeType)) {
            return;
        }
        this.mimeTypesToType.put(mimeType.toLowerCase(), type);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDocumentType(String id) {
        IDocumentType oldType;
        StandardDocumentOutlet standardDocumentOutlet = this;
        synchronized (standardDocumentOutlet) {
            oldType = this.documentTypes.remove(id);
        }
        if (oldType != null) {
            oldType.removeNotificationListener(CreatedEvent.ID, this.listenDocumentCreated);
            AttributeChangedEvent event = new AttributeChangedEvent((Object)this, (Object)"documentTypes", (Object)oldType, null);
            this.triggerEvent((Event)event);
        }
    }
}

