/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.common;

import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;

public class HttpTools {
    private HttpTools() {
    }

    public static boolean containsHeader(Header[] headers, String name) {
        if (headers == null) {
            return false;
        }
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String getContentDisposition(Header[] headers) {
        Header header = HttpTools.getFirstHeader(headers, "content-disposition");
        return header == null ? null : header.getValue();
    }

    public static String getContentDispositionName(Header[] headers, String defaultValue) {
        return HttpTools.getHeaderElementName(headers, "content-disposition", defaultValue);
    }

    public static String getContentDispositionParamFilename(Header[] headers, String defaultValue) {
        return HttpTools.getHeaderElementParam(headers, "content-disposition", "filename", defaultValue);
    }

    public static int getContentLengthName(Header[] headers) {
        String name = HttpTools.getHeaderElementName(headers, "content-length", null);
        if (name != null) {
            try {
                return Integer.parseInt(name.trim());
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static String getContentType(Header[] headers) {
        Header header = HttpTools.getFirstHeader(headers, "Content-Type");
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public static String getContentTypeName(Header[] headers, String defaultValue) {
        return HttpTools.getHeaderElementName(headers, "Content-Type", defaultValue);
    }

    public static String getContentTypeParamCharset(Header[] headers, String defaultValue) {
        return HttpTools.getHeaderElementParam(headers, "Content-Type", "charset", defaultValue);
    }

    public static Header getFirstHeader(Header[] headers, String name) {
        if (headers == null) {
            return null;
        }
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public static String getHeaderElementName(Header header, String defaultValue) {
        HeaderElement[] elements;
        if (header != null && (elements = header.getElements()).length > 0) {
            HeaderElement element = elements[0];
            return element.getName();
        }
        return defaultValue;
    }

    public static String getHeaderElementName(Header[] headers, String name, String defaultValue) {
        HeaderElement[] elements;
        Header header = HttpTools.getFirstHeader(headers, name);
        if (header != null && (elements = header.getElements()).length > 0) {
            HeaderElement element = elements[0];
            return element.getName();
        }
        return defaultValue;
    }

    public static String getHeaderElementName(String header, String defaultValue) {
        if (header == null) {
            return defaultValue;
        }
        return HttpTools.getHeaderElementName((Header)new BasicHeader("", header), defaultValue);
    }

    public static String getHeaderElementParam(Header header, String param, String defaultValue) {
        HeaderElement element;
        NameValuePair nvp;
        HeaderElement[] elements;
        if (header != null && (elements = header.getElements()).length > 0 && (nvp = (element = elements[0]).getParameterByName(param)) != null) {
            return nvp.getValue();
        }
        return defaultValue;
    }

    public static String getHeaderElementParam(Header[] headers, String name, String param, String defaultValue) {
        HeaderElement element;
        NameValuePair nvp;
        HeaderElement[] elements;
        Header header = HttpTools.getFirstHeader(headers, name);
        if (header != null && (elements = header.getElements()).length > 0 && (nvp = (element = elements[0]).getParameterByName(param)) != null) {
            return nvp.getValue();
        }
        return defaultValue;
    }

    public static String getHeaderElementParam(String header, String param, String defaultValue) {
        if (header == null) {
            return defaultValue;
        }
        return HttpTools.getHeaderElementParam((Header)new BasicHeader("", header), param, defaultValue);
    }

    public static Header[] getHeaders(Header[] headers, String name) {
        ArrayList<Header> headersFound = new ArrayList<Header>();
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                Header header = headers[i];
                if (!header.getName().equalsIgnoreCase(name)) continue;
                headersFound.add(header);
            }
        }
        return headersFound.toArray(new Header[headersFound.size()]);
    }

    public static Header getLastHeader(Header[] headers, String name) {
        if (headers == null) {
            return null;
        }
        for (int i = headers.length - 1; i >= 0; --i) {
            Header header = headers[i];
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }
}

