/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.IInstrumentPrerequisite;
import de.intarsys.claptz.InstrumentException;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.InstrumentResolver;
import de.intarsys.claptz.InstrumentTools;
import de.intarsys.claptz.State;
import de.intarsys.claptz.StateExcluded;
import de.intarsys.claptz.StateFailed;
import de.intarsys.claptz.StateNew;
import de.intarsys.claptz.StateStarted;
import de.intarsys.claptz.StateStopped;
import de.intarsys.claptz.impl.PACKAGE;
import de.intarsys.claptz.impl.StandardExtension;
import de.intarsys.claptz.impl.StandardExtensionPoint;
import de.intarsys.claptz.impl.StandardInstrumentClassLoader;
import de.intarsys.claptz.impl.StandardInstrumentPrerequisite;
import de.intarsys.claptz.impl.StandardInstrumentRegistry;
import de.intarsys.claptz.io.IInstrumentStore;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.collection.ReverseListIterator;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.event.StartedEvent;
import de.intarsys.tools.event.StopRequestedEvent;
import de.intarsys.tools.event.StoppedEvent;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.MessageBundleMessageResolver;
import de.intarsys.tools.expression.MessageBundleStringResolver;
import de.intarsys.tools.expression.NLSMessageResolver;
import de.intarsys.tools.expression.NLSStringResolver;
import de.intarsys.tools.format.Format;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.lang.Aliases;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardInstrument
implements IAttributeSupport,
IElementConfigurable,
INotificationSupport,
IInstrument {
    private static final String EL_REQUIRES = "requires";
    private static final String EL_EXTENSION = "extension";
    private static final String ATTR_POINT = "point";
    private static final String VAR_NLSMSG = "nlsmsg";
    private static final String VAR_NLSSTR = "nlsstr";
    private static final String EL_PREREQUISITE = "prerequisite";
    private static final String ATTR_INSTRUMENT = "instrument";
    private static final String VAR_INSTRUMENT = "instrument";
    private static final String ATTR_IFDEF = "ifdef";
    private static final String ATTR_ID = "id";
    private static final String ATTR_IFNOTDEF = "ifnotdef";
    private static final String ATTR_ABSENT = "absent";
    public static final int START_LEVEL_DEFAULT = 50;
    public static final int START_LEVEL_SYSTEM = 0;
    public static final int START_LEVEL_MAX = 99;
    private static final Logger Log = LoggerFactory.getLogger(StandardInstrument.class);
    public static final String META_DEFINITION = "instrument.xml";
    public static final String META_DIRECTORY = "INSTRUMENT-INF";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final boolean CHECK_VISIBILITY = false;
    public static final String ACTION_DEFAULT = null;
    public static final String ACTION_FAIL = "fail";
    public static final String ACTION_IGNORE = "ignore";
    public static final String ACTION_SKIP = "skip";
    private int startLevel = 50;
    private final EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private final IInstrumentStore store;
    private final AttributeMap attributes = new AttributeMap();
    private File baseDir;
    private String bundleName;
    private ClassLoader classLoader;
    private final List<IExtension> extensions = new ArrayList<IExtension>();
    private String id;
    private IMessageBundle messageBundle;
    private final Map<String, String> metaInfo = new HashMap<String, String>();
    private final List<IInstrumentPrerequisite> prerequisites = new ArrayList<IInstrumentPrerequisite>();
    private final StandardInstrumentRegistry registry;
    private State state = new StateNew("");
    private String ifdef;
    private String ifnotdef;
    private MapResolver expressionEvaluator;
    private ILocatorFactory locatorFactory;

    public StandardInstrument(StandardInstrumentRegistry registry, IInstrumentStore store) {
        this.registry = registry;
        this.store = store;
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    @Override
    public void addPrerequisite(IInstrument prerequisite, String absentAction) {
        StandardInstrumentPrerequisite tempPrerequisite = new StandardInstrumentPrerequisite(this);
        tempPrerequisite.setAbsentAction(absentAction);
        tempPrerequisite.setInstrumentId(prerequisite.getId());
        if (!InstrumentTools.isPrerequisiteImplied(this, prerequisite)) {
            this.addPrerequisite(tempPrerequisite);
        }
    }

    protected void addPrerequisite(StandardInstrumentPrerequisite prerequisite) {
        this.prerequisites.add(prerequisite);
    }

    protected List<IInstrumentPrerequisite> basicGetPrerequisites() {
        return this.prerequisites;
    }

    public void configure(IElement element) throws ConfigurationException {
        this.configureInstrument(element);
        IElement eRequires = element.element(EL_REQUIRES);
        if (eRequires != null) {
            this.configurePrerequisistes(eRequires);
        }
        Iterator itExtension = element.elementIterator(EL_EXTENSION);
        while (itExtension.hasNext()) {
            IElement eExtension = (IElement)itExtension.next();
            this.configureExtension(eExtension);
        }
    }

    protected void configureExtension(IElement eExtension) throws ConfigurationException {
        String absent;
        String myIfnotdef;
        String point = eExtension.attributeValue(ATTR_POINT, null);
        if (point == null) {
            throw new ConfigurationException("<extension/> must define 'point' attribute");
        }
        String myId = eExtension.attributeValue(ATTR_ID, null);
        StandardExtension extension = new StandardExtension(this, point, myId);
        String myIfdef = eExtension.attributeValue(ATTR_IFDEF, null);
        if (!StringTools.isEmpty((String)myIfdef)) {
            extension.setIfdef(myIfdef);
        }
        if (!StringTools.isEmpty((String)(myIfnotdef = eExtension.attributeValue(ATTR_IFNOTDEF, null)))) {
            extension.setIfnotdef(myIfnotdef);
        }
        if (!StringTools.isEmpty((String)(absent = eExtension.attributeValue(ATTR_ABSENT, null)))) {
            extension.setAbsentAction(absent);
        }
        extension.setElement(eExtension);
        try {
            this.registerExtension(extension);
        }
        catch (InstrumentRegistryException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void configureInstrument(IElement element) throws ConfigurationException {
        String myIfnotdef;
        String myIfdef;
        String metaVersion;
        String myId = element.attributeValue(ATTR_ID, null);
        if (myId == null) {
            throw new ConfigurationException(Msg.getString("StandardInstrument.ExMustHaveID", new Object[0]));
        }
        this.setId(myId);
        String metaName = element.attributeValue("name", null);
        if (metaName != null) {
            this.setMetaInfo("name", metaName);
        }
        String myBundleName = element.attributeValue("bundle", this.getId() + ".messages");
        this.setMessageBundleName(myBundleName);
        this.expressionEvaluator.put("bundlestr", (Object)new MessageBundleStringResolver(this.getMessageBundle()));
        this.expressionEvaluator.put("bundlemsg", (Object)new MessageBundleMessageResolver(this.getMessageBundle()));
        String metaVendor = element.attributeValue("vendor", null);
        if (metaVendor != null) {
            this.setMetaInfo("vendor", metaVendor);
        }
        if ((metaVersion = element.attributeValue("version", null)) != null) {
            this.setMetaInfo("version", metaVersion);
        }
        if (!StringTools.isEmpty((String)(myIfdef = element.attributeValue(ATTR_IFDEF, null)))) {
            this.setIfdef(myIfdef);
        }
        if (!StringTools.isEmpty((String)(myIfnotdef = element.attributeValue(ATTR_IFNOTDEF, null)))) {
            this.setIfnotdef(myIfnotdef);
        }
        this.setStartLevel(ElementTools.getInt((IElement)element, (String)"startlevel", (int)this.getStartLevel()));
    }

    protected void configurePrerequisiste(IElement element) {
        String myIfnotdef;
        StandardInstrumentPrerequisite prerequisite = new StandardInstrumentPrerequisite(this);
        boolean optional = Converter.asBoolean((String)element.attributeValue("optional", null), (boolean)false);
        if (optional) {
            prerequisite.setAbsentAction(ACTION_IGNORE);
        } else {
            prerequisite.setAbsentAction(element.attributeValue(ATTR_ABSENT, null));
        }
        prerequisite.setInstrumentId(element.attributeValue("instrument", null));
        String myIfdef = element.attributeValue(ATTR_IFDEF, null);
        if (!StringTools.isEmpty((String)myIfdef)) {
            prerequisite.setIfdef(myIfdef);
        }
        if (!StringTools.isEmpty((String)(myIfnotdef = element.attributeValue(ATTR_IFNOTDEF, null)))) {
            prerequisite.setIfnotdef(myIfnotdef);
        }
        this.addPrerequisite(prerequisite);
    }

    protected void configurePrerequisistes(IElement element) {
        Iterator itExtension = element.elementIterator(EL_PREREQUISITE);
        while (itExtension.hasNext()) {
            IElement eExtension = (IElement)itExtension.next();
            this.configurePrerequisiste(eExtension);
        }
    }

    protected ClassLoader createClassLoader() {
        ClassLoader parentLoader = this.getParentLoader();
        ClassLoader result = StandardInstrumentClassLoader.create(this, parentLoader);
        return result;
    }

    protected MapResolver createExpressionEvaluator() {
        MapResolver result = MapResolver.createStrict();
        result.put("instrument", (Object)new InstrumentResolver(this));
        result.put(VAR_NLSSTR, (Object)new NLSStringResolver(this.getClassLoader()));
        result.put(VAR_NLSMSG, (Object)new NLSMessageResolver(this.getClassLoader()));
        return result;
    }

    @Override
    public IExtension createExtension(String extensionPointId, String id) {
        String resolvedId = Aliases.get().resolve(extensionPointId);
        StandardExtension targetExtension = new StandardExtension(this, resolvedId, id);
        IElement extensionElement = ElementFactory.get().createElement(EL_EXTENSION);
        IDocument tempDocument = ElementFactory.get().createDocument();
        ((IStringEvaluatorAccess)tempDocument).setStringEvaluator(this.getExpressionEvaluator());
        tempDocument.setRootElement(extensionElement);
        targetExtension.setElement(extensionElement);
        extensionElement.setAttributeValue(ATTR_POINT, targetExtension.getExtensionPointId());
        extensionElement.setAttributeValue(ATTR_ID, targetExtension.getId());
        return targetExtension;
    }

    @Override
    public void flush() throws IOException {
        if (this.getStore() != null) {
            this.getStore().flush(this);
        }
    }

    public final Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.createClassLoader();
        }
        return this.classLoader;
    }

    public File getDataDir() {
        return FileEnvironment.get().getDataDir();
    }

    public String getDescription() {
        return Msg.getString("StandardInstrument.Description", new Object[]{this.getId(), this.getBaseDir().getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStringEvaluator getExpressionEvaluator() {
        StandardInstrument standardInstrument = this;
        synchronized (standardInstrument) {
            if (this.expressionEvaluator == null) {
                this.expressionEvaluator = this.createExpressionEvaluator();
            }
            return this.expressionEvaluator;
        }
    }

    @Override
    public List<IExtension> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getIfdef() {
        return this.ifdef;
    }

    public String getIfnotdef() {
        return this.ifnotdef;
    }

    @Override
    public StandardInstrumentRegistry getInstrumentRegistry() {
        return this.registry;
    }

    public ILocatorFactory getLocatorFactory() {
        return this.locatorFactory;
    }

    public IMessageBundle getMessageBundle() {
        if (this.messageBundle == null) {
            this.messageBundle = MessageTools.getMessageBundle((String)this.getMessageBundleName(), (ClassLoader)this.getClassLoader());
        }
        return this.messageBundle;
    }

    public String getMessageBundleName() {
        return this.bundleName;
    }

    public String getMetaInfo(String name) {
        return this.metaInfo.get(name);
    }

    protected ClassLoader getParentLoader() {
        return this.getRegistry().getClassLoader();
    }

    @Override
    public List<IInstrumentPrerequisite> getPrerequisites() {
        return this.prerequisites;
    }

    public File getProfileDir() {
        return FileEnvironment.get().getProfileDir();
    }

    protected StandardInstrumentRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public int getStartLevel() {
        return this.startLevel;
    }

    @Override
    public State getState() {
        return this.state;
    }

    public IInstrumentStore getStore() {
        return this.store;
    }

    public File getTempDir() {
        return FileEnvironment.get().getTempDir();
    }

    public File getWorkingDir() {
        return FileEnvironment.get().getWorkingDir();
    }

    protected boolean isCheckVisibility(StandardExtension extension) {
        return true;
    }

    @Override
    public void registerExtension(IExtension extension) throws InstrumentRegistryException {
        this.extensions.add(extension);
        if (this.getState().isStarted()) {
            this.startExtension((StandardExtension)extension);
        }
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public void removePrerequisite(IInstrument prerequisite) {
    }

    public final Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setId(String name) {
        this.id = name;
        this.setMetaInfo(ATTR_ID, name);
    }

    public void setIfdef(String ifdef) {
        this.ifdef = ifdef;
    }

    public void setIfnotdef(String ifnotdef) {
        this.ifnotdef = ifnotdef;
    }

    public void setLocatorFactory(ILocatorFactory locatorFactory) {
        this.locatorFactory = locatorFactory;
    }

    public void setMessageBundle(IMessageBundle bundle) {
        this.messageBundle = bundle;
    }

    public void setMessageBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public void setMetaInfo(String name, String value) {
        this.metaInfo.put(name, value);
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    protected void setState(State state) {
        this.state = state;
    }

    protected void start() {
        if (this.state.isStarted()) {
            return;
        }
        try {
            this.state = new StateStarted("started");
            this.startLocal();
        }
        catch (RuntimeException e) {
            this.state = new StateFailed(e.getLocalizedMessage());
            throw e;
        }
    }

    protected void startExtension(StandardExtension extension) throws InstrumentRegistryException {
        if (!this.registry.ppIsDefined(extension.getIfdef()) || !this.registry.ppIsNotDefined(extension.getIfnotdef())) {
            Log.debug("exclude extension '" + StringTools.safeString((Object)extension));
            return;
        }
        IExtensionPoint extensionPoint = this.getRegistry().lookupExtensionPoint(extension.getExtensionPointId());
        if (extensionPoint == null) {
            String action = extension.getAbsentAction();
            String reason = "missing extensionpoint '" + extension.getExtensionPointId() + "'";
            if (action == ACTION_DEFAULT || action.equals(ACTION_FAIL)) {
                String msg = Format.printf((String)"fail: %s  in '%s' defined in %s", (Object[])new Object[]{reason, extension.getProvider().getId(), extension.getProvider().getBaseDir()});
                InstrumentRegistryException ex = new InstrumentRegistryException(msg);
                extension.setState(new StateFailed(reason));
                extension.getProvider().setState(new StateFailed(reason));
                throw new IllegalArgumentException(ex);
            }
            if (action.equals(ACTION_IGNORE)) {
                Log.info("ignore: {}  in '{}' defined in {}", new Object[]{reason, extension.getProvider().getId(), extension.getProvider().getBaseDir()});
                extension.setState(new StateExcluded(reason));
                return;
            }
            if (action.equals(ACTION_SKIP)) {
                Log.info("skip: {} in '{}' defined in {}", new Object[]{reason, extension.getProvider().getId(), extension.getProvider().getBaseDir()});
                extension.setState(new StateExcluded(reason));
                extension.getProvider().setState(new StateExcluded(reason));
                return;
            }
            InstrumentRegistryException ex = new InstrumentRegistryException("absent action '" + action + "' not recognized in '" + extension.getProvider().getId() + "' defined in " + extension.getProvider().getBaseDir());
            extension.setState(new StateFailed(reason));
            extension.getProvider().setState(new StateFailed(reason));
            throw new IllegalArgumentException(ex);
        }
        Log.debug("register {}", (Object)StringTools.safeString((Object)extension));
        ((StandardExtensionPoint)extensionPoint).registerExtension(extension);
    }

    protected void startExtensions() {
        for (StandardExtension standardExtension : this.extensions) {
            try {
                this.startExtension(standardExtension);
                if (this.isCheckVisibility(standardExtension)) continue;
                throw new InstrumentException("invisible " + StringTools.safeString((Object)standardExtension));
            }
            catch (InstrumentRegistryException e) {
                throw new InstrumentException(StringTools.safeString((Object)standardExtension) + " error when registering", e);
            }
        }
    }

    protected boolean startLocal() throws InstrumentException {
        Log.debug("register extensions for {}", (Object)StringTools.safeString((Object)this));
        this.startExtensions();
        Log.debug("register extensions ready for {}", (Object)StringTools.safeString((Object)this));
        return true;
    }

    protected void stop() {
        if (this.state.isStopped()) {
            return;
        }
        this.state = new StateStopped("stopped");
        this.stopLocal();
        this.dispatcher.triggerEvent((Event)new StoppedEvent((Object)this));
    }

    protected void stopExtension(StandardExtension extension) throws InstrumentRegistryException {
        IExtensionPoint extensionPoint = this.getRegistry().lookupExtensionPoint(extension.getExtensionPointId());
        if (extensionPoint == null) {
            return;
        }
        ((StandardExtensionPoint)extensionPoint).unregisterExtension(extension);
        Log.trace("unregistered {}", (Object)StringTools.safeString((Object)extension));
    }

    protected void stopExtensions() {
        ReverseListIterator it = new ReverseListIterator(this.extensions);
        while (it.hasNext()) {
            StandardExtension extension = (StandardExtension)it.next();
            try {
                this.stopExtension(extension);
            }
            catch (InstrumentRegistryException e) {
                throw new InstrumentException(StringTools.safeString((Object)extension) + " error when unregistering", e);
            }
        }
    }

    protected void stopLocal() {
        Log.trace("unregister extensions for {}", (Object)StringTools.safeString((Object)this));
        this.stopExtensions();
    }

    protected boolean stopRequested(Set<?> visited) {
        StopRequestedEvent event = new StopRequestedEvent((Object)this, visited);
        this.dispatcher.triggerEvent((Event)event);
        return !event.isVetoed();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IInstrument '");
        sb.append(this.getId());
        sb.append("' defined in '");
        sb.append(this.getBaseDir());
        sb.append("'");
        return sb.toString();
    }

    protected void triggerChanged(String attribute, Object oldValue, Object newValue) {
        this.dispatcher.triggerChanged((Object)attribute, oldValue, newValue);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }

    protected void triggerStarted() {
        if (!this.state.isStarted()) {
            return;
        }
        try {
            this.dispatcher.triggerEvent((Event)new StartedEvent((Object)this));
        }
        catch (RuntimeException e) {
            this.state = new StateFailed(e.getLocalizedMessage());
            throw e;
        }
    }

    @Override
    public void unregisterExtension(IExtension extension) throws InstrumentRegistryException {
        if (this.extensions.remove(extension) && this.getState().isStarted()) {
            this.stopExtension((StandardExtension)extension);
        }
    }
}

