/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.tools.file.FileLoader;
import de.intarsys.tools.infoset.IElement;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ExtensionPointLoaderAdapter
extends ExtensionPointHandlerAdapter {
    public static final String VALUE_FALSE = "false";
    public static final String EA_READONLY = "readonly";
    public static final String EA_RECURSIVE = "recursive";
    public static final String XE_LOADNLS = "loadnls";
    public static final String EA_PATH = "path";
    public static final String XE_LOAD = "load";
    private static final Logger Log = LoggerFactory.getLogger(ExtensionPointLoaderAdapter.class);
    private FileLoader loader;

    public ExtensionPointLoaderAdapter() {
        this(null);
    }

    public ExtensionPointLoaderAdapter(FileLoader loader) {
        this.loader = loader == null ? this.createLoader() : loader;
    }

    @Override
    protected Object basicInstallInsert(IExtension extension, IElement element) {
        File parentDir = extension.getProvider().getBaseDir();
        if (XE_LOAD.equals(element.getName())) {
            String path = element.attributeValue(EA_PATH, null);
            boolean readOnly = Boolean.parseBoolean(element.attributeValue(EA_READONLY, VALUE_FALSE));
            boolean recursive = Boolean.parseBoolean(element.attributeValue(EA_RECURSIVE, VALUE_FALSE));
            try {
                this.loader.load(parentDir, path, readOnly, recursive);
            }
            catch (Exception e) {
                String msg = "error loading " + path;
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else if (XE_LOADNLS.equals(element.getName())) {
            String path = element.attributeValue(EA_PATH, null);
            boolean readOnly = Boolean.parseBoolean(element.attributeValue(EA_READONLY, VALUE_FALSE));
            boolean recursive = Boolean.parseBoolean(element.attributeValue(EA_RECURSIVE, VALUE_FALSE));
            try {
                this.loader.loadNLS(parentDir, path, readOnly, recursive);
            }
            catch (Exception e) {
                String msg = "error loading " + path;
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        return null;
    }

    protected boolean basicLoadFile(File file, boolean readOnly) throws IOException {
        return true;
    }

    protected FileLoader createLoader() {
        return new FileLoader(){

            protected boolean basicLoadFile(File file, boolean readOnly, String path) throws IOException {
                return ExtensionPointLoaderAdapter.this.basicLoadFile(file, readOnly);
            }
        };
    }
}

