/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.extension.runtime;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.tools.adapter.AdapterOutlet;
import de.intarsys.tools.adapter.GenericAdapterFactory;
import de.intarsys.tools.adapter.IAdapterFactory;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class AdapterFactoryInstaller
extends ExtensionPointHandlerAdapter {
    private static final Logger Log = LoggerFactory.getLogger(AdapterFactoryInstaller.class);
    public static final String XE_ADAPTERFACTORY = "adapterfactory";
    public static final String XE_ADAPTER = "adapter";

    @Override
    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_ADAPTERFACTORY.equals(element.getName())) {
            try {
                IAdapterFactory adapterFactory = (IAdapterFactory)ElementTools.createObject((IElement)element, IAdapterFactory.class, (Object)extension.getProvider(), (IArgs)Args.create());
                AdapterOutlet.get().registerAdapterFactory(adapterFactory);
                return adapterFactory;
            }
            catch (Exception e) {
                String msg = "error creating adapter factory";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else if (XE_ADAPTER.equals(element.getName())) {
            try {
                GenericAdapterFactory adapterFactory = new GenericAdapterFactory();
                adapterFactory.setContext((Object)extension.getProvider());
                adapterFactory.configure(element);
                AdapterOutlet.get().registerAdapterFactory((IAdapterFactory)adapterFactory);
                return adapterFactory;
            }
            catch (Exception e) {
                String msg = "error creating generic adapter factory";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        return null;
    }
}

