/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.IInstrumentPrerequisite;
import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.ExtensionOperation;
import de.intarsys.claptz.io.IInstrumentStore;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.lang.Aliases;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstrumentTools {
    private static final Logger Log = LoggerFactory.getLogger(InstrumentTools.class);

    public static IExtension getLastExtension(IInstrumentRegistry registry, String extensionPointId) {
        IExtensionPoint ep = registry.lookupExtensionPoint(extensionPointId);
        if (ep == null) {
            Log.warn("extension point '{}' not found", (Object)extensionPointId);
            return null;
        }
        List<IExtension> extensions = ep.getExtensions();
        if (!extensions.isEmpty()) {
            return extensions.get(extensions.size() - 1);
        }
        return null;
    }

    public static IExtension getOrCreateExtension(IInstrument provider, String extensionPointId, String id) throws ObjectCreationException, InstrumentRegistryException {
        String resolvedId = Aliases.get().resolve(extensionPointId);
        List<IExtension> extensions = provider.getExtensions();
        IExtension targetExtension = null;
        for (IExtension extension : extensions) {
            if (!extension.getExtensionPoint().getId().equals(resolvedId) || id != null && !extension.getId().equals(id)) continue;
            targetExtension = extension;
            break;
        }
        if (targetExtension == null) {
            targetExtension = provider.createExtension(resolvedId, id);
            IInstrument prerequisiteProvider = provider.getInstrumentRegistry().lookupExtensionPoint(resolvedId).getProvider();
            provider.addPrerequisite(prerequisiteProvider, "skip");
            provider.registerExtension(targetExtension);
        }
        return targetExtension;
    }

    public static void installExtensions(IInstrumentRegistry registry, String point, IExtensionPointHandler functor) throws InstrumentRegistryException {
        IExtensionPoint extensionPoint = registry.lookupExtensionPoint(point);
        if (extensionPoint == null) {
            Log.warn("extension point '{}' not found", (Object)point);
            return;
        }
        functor.setExtensionPoint(extensionPoint);
        functor.install();
    }

    public static boolean isPrerequisiteImplied(IInstrument instrument, IInstrument requiredInstrument) {
        if (requiredInstrument == instrument) {
            return true;
        }
        if (requiredInstrument == null) {
            return true;
        }
        if (instrument == null) {
            return false;
        }
        if (requiredInstrument.getStartLevel() < instrument.getStartLevel()) {
            return true;
        }
        for (IInstrumentPrerequisite prerequisite : instrument.getPrerequisites()) {
            IInstrument tempInstrument = prerequisite.getInstrument();
            if (!InstrumentTools.isPrerequisiteImplied(tempInstrument, requiredInstrument)) continue;
            return true;
        }
        return false;
    }

    public static IExtension lookupDefiningExtension(IExtensionPoint extensionPoint, Object object) {
        List<IExtension> extensions = extensionPoint.getExtensions();
        for (IExtension extension : extensions) {
            List<ExtensionOperation> attachments = extension.getOperations();
            for (ExtensionOperation attachment : attachments) {
                if (!attachment.isInsert() || attachment.getObject() != object) continue;
                return extension;
            }
        }
        return null;
    }

    public static IInstrument lookupInstrument(IInstrumentRegistry registry, String instrumentId) {
        IInstrument iInstrument = registry.lookupInstrument(instrumentId);
        if (iInstrument == null) {
            return null;
        }
        return iInstrument.getState().isStarted() ? iInstrument : null;
    }

    public static IInstrument lookupOrCreateInstrument(IInstrumentRegistry registry, String instrumentId, IInstrumentStore store) throws ObjectCreationException, InstrumentRegistryException {
        Object tempId = instrumentId;
        int counter = 1;
        IInstrument iInstrument = registry.lookupInstrument((String)tempId);
        while (iInstrument != null && !iInstrument.getState().isStarted()) {
            tempId = instrumentId + "." + counter++;
            iInstrument = registry.lookupInstrument((String)tempId);
        }
        if (iInstrument == null) {
            iInstrument = registry.createInstrument((String)tempId, store);
            registry.registerInstrument(iInstrument);
        }
        return iInstrument;
    }

    public static IExtension objectDelete(IInstrument provider, String extensionPointId, Object target) throws ObjectCreationException, InstrumentRegistryException, InstrumentRegistryException {
        IExtensionPointHandler installer;
        IInstrument targetProvider = null;
        IExtension targetExtension = null;
        if (provider == null) {
            throw new IllegalArgumentException("provider can't be null");
        }
        targetProvider = provider;
        targetExtension = InstrumentTools.getOrCreateExtension(targetProvider, extensionPointId, null);
        targetExtension.attachDelete(target);
        IExtension tempExtension = InstrumentTools.lookupDefiningExtension(targetExtension.getExtensionPoint(), target);
        if (tempExtension != null) {
            IInstrument tempProvider = tempExtension.getProvider();
            provider.addPrerequisite(tempProvider, "skip");
        }
        if ((installer = targetExtension.getExtensionPoint().getInstaller()) != null) {
            installer.update(targetExtension);
        }
        return targetExtension;
    }

    public static IExtension objectInsert(IInstrument provider, String extensionPointId, Object target) throws ObjectCreationException, InstrumentRegistryException {
        IExtensionPointHandler installer;
        IExtension tempExtension;
        IInstrument targetProvider = null;
        IExtension targetExtension = null;
        if (provider == null) {
            throw new IllegalArgumentException("provider can't be null");
        }
        targetProvider = provider;
        targetExtension = InstrumentTools.getOrCreateExtension(targetProvider, extensionPointId, null);
        targetExtension.attachInsert(target);
        if (target instanceof IContextSupport) {
            try {
                ((IContextSupport)target).setContext((Object)targetExtension.getProvider());
            }
            catch (ConfigurationException e) {
                throw new InstrumentRegistryException(e.getLocalizedMessage(), e);
            }
        }
        if ((tempExtension = InstrumentTools.lookupDefiningExtension(targetExtension.getExtensionPoint(), target)) != null) {
            IInstrument tempProvider = tempExtension.getProvider();
            targetProvider.addPrerequisite(tempProvider, "skip");
        }
        if ((installer = targetExtension.getExtensionPoint().getInstaller()) != null) {
            installer.update(targetExtension);
        }
        return targetExtension;
    }

    public static IExtension objectUpdate(IInstrument provider, String extensionPointId, Object target) throws ObjectCreationException, InstrumentRegistryException {
        IExtensionPointHandler installer;
        IInstrument targetProvider = null;
        IExtension targetExtension = null;
        if (provider == null) {
            throw new IllegalArgumentException("provide can't be null");
        }
        targetProvider = provider;
        targetExtension = InstrumentTools.getOrCreateExtension(targetProvider, extensionPointId, null);
        targetExtension.attachUpdate(target);
        IExtension tempExtension = InstrumentTools.lookupDefiningExtension(targetExtension.getExtensionPoint(), target);
        if (tempExtension != null) {
            IInstrument tempProvider = tempExtension.getProvider();
            provider.addPrerequisite(tempProvider, "skip");
        }
        if ((installer = targetExtension.getExtensionPoint().getInstaller()) != null) {
            installer.update(targetExtension);
        }
        return targetExtension;
    }

    public static void uninstallExtensions(IInstrumentRegistry registry, String point, IExtensionPointHandler functor) throws InstrumentRegistryException {
        IExtensionPoint extensionPoint = registry.lookupExtensionPoint(point);
        if (extensionPoint == null) {
            Log.warn("extension point '" + point + "' not found");
            return;
        }
        functor.uninstall();
    }

    private InstrumentTools() {
    }
}

