/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.xmp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jempbox.impl.XMLUtil;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.jempbox.xmp.property.PropertyResourceEvent;
import org.jempbox.xmp.property.PropertyResourceRef;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMPSchemaMediaManagement
extends XMPSchema {
    public static final String NAMESPACE = "http://ns.adobe.com/xap/1.0/mm/";
    protected static final String basePrefix = "xmpMM";
    protected static final String basePrefixDepr = "xapMM";
    protected static List<String> propertyNames = Arrays.asList("xmpMM:DerivedFrom", "xmpMM:InstanceID", "xmpMM:DocumentID", "xmpMM:History", "xmpMM:ManagedFrom", "xmpMM:Manager", "xmpMM:ManageTo", "xmpMM:ManageUI", "xmpMM:ManagerVariant", "xmpMM:RenditionClass", "xmpMM:RenditionParams", "xmpMM:VersionID", "xmpMM:Versions", "xmpMM:LastURL", "xmpMM:RenditionOf", "xmpMM:SaveID", "xapMM:DerivedFrom", "xapMM:InstanceID", "xapMM:DocumentID", "xapMM:History", "xapMM:ManagedFrom", "xapMM:Manager", "xapMM:ManageTo", "xapMM:ManageUI", "xapMM:ManagerVariant", "xapMM:RenditionClass", "xapMM:RenditionParams", "xapMM:VersionID", "xapMM:Versions", "xapMM:LastURL", "xmpMM:RenditionOf", "xapMM:SaveID");

    public XMPSchemaMediaManagement(Element element, String prefix) {
        super(element, prefix);
    }

    public XMPSchemaMediaManagement(XMPMetadata parent) {
        super(parent, basePrefix, NAMESPACE);
    }

    public void addHistory(PropertyResourceEvent event) {
        this.addSequenceValue(this.prefix + ":History", event);
    }

    public PropertyResourceRef createDerivedFrom() {
        Element node = this.schema.getOwnerDocument().createElement(this.prefix + ":DerivedFrom");
        PropertyResourceRef ref = new PropertyResourceRef(node);
        return ref;
    }

    public PropertyResourceRef createManagedFrom() {
        Element node = this.schema.getOwnerDocument().createElement(this.prefix + ":ManagedFrom");
        PropertyResourceRef ref = new PropertyResourceRef(node);
        return ref;
    }

    public PropertyResourceRef getDerivedFrom() {
        PropertyResourceRef retval = null;
        NodeList nodes = this.schema.getElementsByTagName(this.prefix + ":DerivedFrom");
        if (nodes.getLength() > 0) {
            Element derived = (Element)nodes.item(0);
            retval = new PropertyResourceRef(derived);
        } else {
            NodeList deprecatedNodes = this.schema.getElementsByTagName(this.prefix + ":RenditionOf");
            if (deprecatedNodes.getLength() > 0) {
                Element derived = (Element)deprecatedNodes.item(0);
                retval = new PropertyResourceRef(derived);
            }
        }
        return retval;
    }

    public String getDocumentID() {
        return this.getTextProperty(this.prefix + ":DocumentID");
    }

    public List getHistory() {
        return this.getEventSequenceList(this.prefix + ":History");
    }

    public String getInstanceID() {
        return this.getTextProperty(this.prefix + ":InstanceID");
    }

    public PropertyResourceRef getManagedFrom() {
        PropertyResourceRef retval = null;
        NodeList nodes = this.schema.getElementsByTagName(this.prefix + ":ManagedFrom");
        if (nodes.getLength() > 0) {
            Element derived = (Element)nodes.item(0);
            retval = new PropertyResourceRef(derived);
        }
        return retval;
    }

    public String getManager() {
        return this.getTextProperty(this.prefix + ":Manager");
    }

    public String getManageTo() {
        return this.getTextProperty(this.prefix + ":ManageTo");
    }

    public String getManageUI() {
        return this.getTextProperty(this.prefix + ":ManageUI");
    }

    @Override
    protected List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(propertyNames);
        result.addAll(PropertyResourceRef.propertyNames);
        result.addAll(PropertyResourceEvent.stEvtPropertyNames);
        result.addAll(PropertyResourceEvent.stVerPropertyNames);
        return result;
    }

    public String getVersionID() {
        return this.getTextProperty(this.prefix + ":VersionID");
    }

    public void removeHistory(PropertyResourceEvent event) {
        this.removeSequenceValue(this.prefix + ":History", event);
    }

    public void setDerivedFrom(PropertyResourceRef resource) {
        XMLUtil.setElementableValue(this.schema, this.prefix + ":DerivedFrom", resource);
    }

    public void setDocumentID(String id) {
        this.setTextProperty(this.prefix + ":DocumentID", id);
    }

    public void setInstanceID(String id) {
        this.setTextProperty(this.prefix + ":InstanceID", id);
    }

    public void setManagedFrom(PropertyResourceRef resource) {
        XMLUtil.setElementableValue(this.schema, this.prefix + ":DerivedFrom", resource);
    }

    public void setManager(String manager) {
        this.setTextProperty(this.prefix + ":Manager", manager);
    }

    public void setManageTo(String uri) {
        this.setTextProperty(this.prefix + ":ManageTo", uri);
    }

    public void setManageUI(String uri) {
        this.setTextProperty(this.prefix + ":ManageUI", uri);
    }

    public void setVersionID(String id) {
        this.setTextProperty(this.prefix + ":VersionID", id);
    }
}

