/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.unit;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.units.ri.AbstractUnit;
import tec.uom.lib.common.function.UnitConverterSupplier;

public final class TransformedUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q>
implements UnitConverterSupplier {
    private final AbstractUnit<Q> parentUnit;
    private final Unit<Q> systemUnit;
    private final UnitConverter converter;
    private String symbol;

    public TransformedUnit(String symbol, Unit<Q> parentUnit, Unit<Q> sysUnit, UnitConverter unitConverter) {
        if (!(parentUnit instanceof AbstractUnit)) {
            throw new IllegalArgumentException("The parent unit: " + parentUnit + " is not an abstract unit.");
        }
        AbstractUnit abParent = (AbstractUnit)parentUnit;
        this.systemUnit = sysUnit;
        this.parentUnit = abParent;
        this.converter = unitConverter;
        this.symbol = symbol;
    }

    public TransformedUnit(AbstractUnit<Q> parentUnit, UnitConverter unitConverter) {
        this(null, parentUnit, unitConverter);
    }

    public TransformedUnit(String symbol, Unit<Q> parentUnit, UnitConverter unitConverter) {
        this(null, parentUnit, parentUnit.getSystemUnit(), unitConverter);
    }

    public TransformedUnit(Unit<Q> parentUnit, UnitConverter toParentUnit) {
        this((AbstractUnit)parentUnit, toParentUnit);
    }

    @Override
    public Dimension getDimension() {
        return this.parentUnit.getDimension();
    }

    @Override
    public UnitConverter getSystemConverter() {
        return this.parentUnit.getSystemConverter().concatenate(this.converter);
    }

    @Override
    public AbstractUnit<Q> toSystemUnit() {
        return this.parentUnit.getSystemUnit();
    }

    @Override
    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return this.parentUnit.getBaseUnits();
    }

    @Override
    public int hashCode() {
        return this.parentUnit.hashCode() + this.converter.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof TransformedUnit)) {
            return false;
        }
        TransformedUnit thatUnit = (TransformedUnit)that;
        return this.parentUnit.equals(thatUnit.parentUnit) && this.converter.equals(thatUnit.converter);
    }

    @Override
    public String getSymbol() {
        if (super.getSymbol() != null) {
            return super.getSymbol();
        }
        return this.symbol;
    }

    public Unit<Q> getParentUnit() {
        return this.parentUnit;
    }

    public UnitConverter getConverter() {
        return this.converter;
    }
}

