/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license.mbean;

import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.mbean.CommonMBean;
import de.intarsys.tools.license.mbean.LicenseAccountMBeanMBean;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class LicenseAccountMBean
extends CommonMBean
implements LicenseAccountMBeanMBean {
    private final ILicenseAccount account;

    public LicenseAccountMBean(ILicenseAccount account) {
        this.account = account;
    }

    protected ILicenseAccount getAccount() {
        return this.account;
    }

    @Override
    public int getBalance() {
        return this.account.getBalance();
    }

    @Override
    public String getId() {
        return this.account.getName() + "@" + this.account.getLicenseProduct().getId();
    }

    @Override
    public String getLabel() {
        return this.account.getLabel();
    }

    @Override
    public int getLimit() {
        return this.account.getLimit();
    }

    @Override
    public String getNextReset() {
        return this.account.getNextReset() == null ? null : DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault()).format(this.account.getNextReset());
    }

    @Override
    public String getProduct() {
        return this.account.getLicenseProduct().getId();
    }

    @Override
    public String getProperty() {
        return this.account.getName();
    }

    @Override
    public String getType() {
        return "LicenseAccount";
    }

    @Override
    public String getUnit() {
        return this.account.getLicenseProperty().getUnit().getId();
    }
}

