/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseRepository
implements INotificationSupport {
    private static final Logger Log = LoggerFactory.getLogger(LicenseRepository.class);
    public static final Object ATTR_LICENSES = new Object();
    private final LicenseEnvironment licenseEnvironment;
    private final Map<String, Boolean> authorized = new HashMap<String, Boolean>();
    private boolean initialized = false;
    private final List<License> licenses = new ArrayList<License>();
    private final EventDispatcher dispatcher = new EventDispatcher((Object)this);

    public LicenseRepository(LicenseEnvironment environment) {
        this.licenseEnvironment = environment;
    }

    public void addChangeListener(INotificationListener listener) {
        this.dispatcher.addNotificationListener(AttributeChangedEvent.ID, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLicense(License license) throws LicenseException {
        if (!this.exists(license)) {
            LicenseRepository licenseRepository = this;
            synchronized (licenseRepository) {
                this.initialized = false;
                this.licenses.add(license);
            }
            Log.info("license '" + StringTools.safeString((Object)license) + "' loaded");
            this.triggerChanged(ATTR_LICENSES, null, license);
            return true;
        }
        return false;
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    private final synchronized void checkAuthorization() {
        if (this.initialized) {
            return;
        }
        LicenseProduct product = this.getLicenseEnvironment().getLicenseProduct();
        if (product == null) {
            this.authorized.clear();
        } else {
            this.initialized = true;
            List<License> licsAuthorized = this.getLicensesAuthorized(product);
            if (LicenseTools.getLicensePropertyWithValueState(licsAuthorized, "id", product.getId()).isAuthorized()) {
                this.authorized.put("", true);
            }
            if (LicenseTools.getLicensePropertyWithValueState(licsAuthorized, "bundle", "basic").isAuthorized()) {
                this.authorized.put("basic", true);
            }
            if (LicenseTools.getLicensePropertyWithValueState(licsAuthorized, "bundle", "professional").isAuthorized()) {
                this.authorized.put("basic", true);
                this.authorized.put("professional", true);
            }
        }
    }

    public boolean exists(License license) {
        for (License tempLicense : this.licenses) {
            if (!tempLicense.equals(license)) continue;
            return true;
        }
        return false;
    }

    public LicenseEnvironment getLicenseEnvironment() {
        return this.licenseEnvironment;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public List<License> getLicensesAuthorized(LicenseProduct product) {
        ArrayList<License> result = new ArrayList<License>();
        for (License license : this.getLicenses()) {
            if (license.getState(product).isNotAuthorized()) continue;
            result.add(license);
        }
        return result;
    }

    public List<License> getLicensesAuthorizedGlobal() {
        ArrayList<License> result = new ArrayList<License>();
        for (License license : this.getLicenses()) {
            LicenseProduct product;
            if (license.getState(product = this.getLicenseEnvironment().lookupProduct(license.getProductId())).isNotAuthorized()) continue;
            result.add(license);
        }
        return result;
    }

    public final boolean isAuthorized() {
        this.checkAuthorization();
        return Boolean.TRUE.equals(this.authorized.get(""));
    }

    public final boolean isAuthorized(String bundle) {
        this.checkAuthorization();
        return Boolean.TRUE.equals(this.authorized.get(bundle));
    }

    public void removeChangeListener(INotificationListener listener) {
        this.dispatcher.removeNotificationListener(AttributeChangedEvent.ID, listener);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    public synchronized void reset() {
        this.initialized = false;
        this.authorized.clear();
        this.licenses.clear();
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, attribute, oldValue, newValue);
        this.dispatcher.triggerEvent((Event)event);
    }
}

