/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.string.StringTools;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class LicenseProperty {
    public static final LicenseProperty NA = LicenseProperty.create(License.NA, "na", "0", LicensePropertyUnit.DEFAULT, "", false);
    private final String name;
    private final String value;
    private final String[] options;
    private final Map<String, String> optionMap;
    private final LicensePropertyUnit unit;
    private final License license;
    private final boolean generic;

    public static LicenseProperty create(License license, String name, String encodedValueUnitOption, boolean generic) throws LicenseException {
        String[] splitValueUnitOption = encodedValueUnitOption.split("\\|", 2);
        String encodedValueUnit = splitValueUnitOption[0];
        String attrOptions = null;
        if (splitValueUnitOption.length > 1) {
            attrOptions = splitValueUnitOption[1];
        }
        return LicenseProperty.create(license, name, encodedValueUnit, attrOptions, generic);
    }

    protected static LicenseProperty create(License license, String name, String attrValue, LicensePropertyUnit attrUnit, String options, boolean generic) {
        if (attrUnit == null) {
            throw new IllegalArgumentException("unit can not be null");
        }
        String[] attrOptions = null;
        if (!StringTools.isEmpty((String)options)) {
            attrOptions = options.split("\\|");
        }
        return new LicenseProperty(license, name, attrValue, attrUnit, attrOptions, generic);
    }

    public static LicenseProperty create(License license, String name, String value, String options, boolean generic) {
        String attrValue = null;
        LicensePropertyUnit attrUnit = LicensePropertyUnit.DEFAULT;
        String[] splitValueUnit = value.split("\\:", 2);
        attrValue = splitValueUnit[0].trim();
        try {
            Integer.parseInt(attrValue);
            if (splitValueUnit.length > 1 && !StringTools.isEmpty((String)splitValueUnit[1])) {
                attrUnit = LicensePropertyUnit.getUnit(splitValueUnit[1]);
            }
        }
        catch (Exception e) {
            attrValue = value;
        }
        return LicenseProperty.create(license, name, attrValue, attrUnit, options, generic);
    }

    protected LicenseProperty(License license, String name, String value, LicensePropertyUnit unit, String[] options, boolean generic) {
        this.license = license;
        this.name = name;
        this.value = value;
        this.unit = unit;
        this.options = options;
        if (options != null) {
            this.optionMap = new HashMap<String, String>();
            for (int i = 0; i < options.length; ++i) {
                String[] split = options[i].split("\\=");
                if (split.length == 1) {
                    this.optionMap.put(split[0], "");
                    continue;
                }
                this.optionMap.put(split[0], split[1]);
            }
        } else {
            this.optionMap = null;
        }
        this.generic = generic;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LicenseProperty)) {
            return false;
        }
        LicenseProperty other = (LicenseProperty)obj;
        return LangTools.equals((Object)this.name, (Object)other.name) && LangTools.equals((Object)this.value, (Object)other.value) && LangTools.equals((Object)this.unit, (Object)other.unit);
    }

    public float getCanonicalValue() {
        if (this.getUnit() == null || this.getValueFloat() == -1.0f) {
            return this.getValueFloat();
        }
        return this.getUnit().getCanonicalValue(this.getValueFloat());
    }

    public License getLicense() {
        return this.license;
    }

    public String getName() {
        return this.name;
    }

    public String getNameValueUnitString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("=");
        sb.append(this.getValueUnitString());
        return sb.toString();
    }

    public String getOption(int index) {
        if (this.options == null || index < 0 || index >= this.options.length) {
            return null;
        }
        return this.options[index];
    }

    public String getOption(String name) {
        if (this.optionMap == null) {
            return null;
        }
        return this.optionMap.get(name);
    }

    public int getOptionCount() {
        if (this.options == null) {
            return 0;
        }
        return this.options.length;
    }

    public String getOptionsString() {
        StringBuilder sb = new StringBuilder();
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                if (i != 0) {
                    sb.append("|");
                }
                sb.append(this.options[i]);
            }
        }
        return sb.toString();
    }

    public String getQualifiedName() {
        return this.getName() + "@" + this.license.getProductId();
    }

    public LicensePropertyUnit getUnit() {
        return this.unit;
    }

    public String getValue() {
        return this.value;
    }

    public float getValueFloat() {
        try {
            return Float.parseFloat(this.getValue());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public int getValueInt() {
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getValueUnitString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getValue());
        if (this.getUnit() != LicensePropertyUnit.DEFAULT) {
            sb.append(":");
            sb.append(this.getUnit().getId());
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.unit);
    }

    public boolean isDefined() {
        return this.getLicense().isDefined();
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public boolean isUnlimited() {
        return this.getValueFloat() < 0.0f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("license '");
        sb.append(this.license.getProductId());
        sb.append("' property '");
        sb.append(this.name);
        sb.append("'='");
        sb.append(this.getValueUnitString());
        sb.append("'");
        return sb.toString();
    }
}

