/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.component.IMetaInfoSupport;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseAccount;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LicenseProduct
implements IContextSupport,
IElementConfigurable {
    public static final String PRODUCT_ID_NA = "de.intarsys.license.unavailable";
    public static final String PRODUCT_ID_GLOBAL = "de.intarsys.license.global";
    public static LicenseProduct NA;
    public static LicenseProduct GLOBAL;
    private Object context;
    private boolean main = false;
    private String id;
    private String label;
    private String version;
    private boolean sealed;
    private boolean free;
    private final Map<String, ILicenseAccount> accounts = new ConcurrentHashMap<String, ILicenseAccount>();

    protected static void installStandardProducts() {
        NA = new LicenseProduct(PRODUCT_ID_NA);
        GLOBAL = new LicenseProduct(PRODUCT_ID_GLOBAL);
    }

    public LicenseProduct() {
    }

    private LicenseProduct(String id) {
        this();
        this.id = id;
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setMain(ElementTools.getBool((IElement)element, (String)"main", (boolean)false));
    }

    public ILicenseAccount getAccount(String property) {
        return this.accounts.computeIfAbsent(property, key -> new LicenseAccount(this, (String)key));
    }

    public List<ILicenseAccount> getAccounts() {
        return new ArrayList<ILicenseAccount>(this.accounts.values());
    }

    public Object getContext() {
        return this.context;
    }

    public String getId() {
        if (this.context instanceof IMetaInfoSupport) {
            return ((IMetaInfoSupport)this.context).getMetaInfo("id");
        }
        return this.id;
    }

    public String getLabel() {
        if (this.label == null) {
            String code = "LicenseProduct." + this.getId() + ".label";
            IMessageBundle bundle = this.getMessageBundle();
            String pattern = bundle.getPattern(code);
            if (pattern == null) {
                return this.getName();
            }
            return bundle.format(pattern, new Object[0]);
        }
        return this.label;
    }

    protected IMessageBundle getMessageBundle() {
        if (this.getContext() != null) {
            Object object = this.getContext();
            if (object instanceof Class) {
                Class clazz = (Class)object;
                return MessageTools.getMessageBundle((Class)clazz);
            }
            return MessageTools.getMessageBundle(this.getContext().getClass());
        }
        return MessageTools.getMessageBundle(this.getClass());
    }

    public String getName() {
        if (this.context instanceof IMetaInfoSupport) {
            return ((IMetaInfoSupport)this.context).getMetaInfo("name");
        }
        return this.getId();
    }

    public String getVersion() {
        if (this.context instanceof IMetaInfoSupport) {
            return ((IMetaInfoSupport)this.context).getMetaInfo("version");
        }
        return this.version;
    }

    public boolean isFree() {
        return this.free;
    }

    public boolean isMain() {
        return this.main;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public void seal() {
        this.sealed = true;
    }

    public final void setContext(Object context) {
        if (this.isSealed()) {
            throw new LicenseException("license tampering");
        }
        this.context = context;
    }

    public void setFree(boolean free) {
        if (this.isSealed()) {
            throw new LicenseException("license tampering");
        }
        this.free = free;
    }

    public void setId(String id) {
        if (this.isSealed()) {
            throw new LicenseException("license tampering");
        }
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMain(boolean main) {
        if (this.isSealed()) {
            throw new LicenseException("license tampering");
        }
        this.main = main;
    }

    public void setVersion(String version) {
        if (this.isSealed()) {
            throw new LicenseException("license tampering");
        }
        this.version = version;
    }

    public String toString() {
        return "license product " + this.getId() + ", v." + this.getVersion();
    }
}

