/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.cli;

import de.intarsys.tools.cli.CLIOptionDescriptor;
import de.intarsys.tools.cli.ICLIOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CLIOption
implements ICLIOption {
    private List values = new ArrayList();
    private CLIOptionDescriptor descriptor;
    private String shortName;
    private String longName;
    private boolean processed = false;
    private boolean hidden = false;

    public CLIOption(CLIOptionDescriptor descriptor) {
        this.descriptor = descriptor;
        this.shortName = descriptor.getOpt();
        this.longName = descriptor.getLongOpt();
    }

    public CLIOption(String shortName, String longName) {
        this.shortName = shortName;
        this.longName = longName;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public CLIOptionDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getLongName() {
        return this.longName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getValue() {
        return this.values.isEmpty() ? null : (String)this.values.get(0);
    }

    @Override
    public String getValue(int index) {
        return this.values.size() <= index ? null : (String)this.values.get(index);
    }

    @Override
    public String getValue(int index, String defaultValue) {
        String value = this.getValue(index);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getValue(String defaultValue) {
        String value = this.getValue();
        return value != null ? value : defaultValue;
    }

    @Override
    public String[] getValues() {
        return this.values.isEmpty() ? new String[]{} : this.values.toArray(new String[0]);
    }

    protected List getValuesList() {
        return this.values;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    protected void setDescriptor(CLIOptionDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.longName == null) {
            sb.append("-");
            sb.append(this.shortName);
        } else {
            sb.append("--");
            sb.append(this.longName);
        }
        if (this.isHidden()) {
            sb.append(" ***");
        } else {
            Iterator it = this.values.iterator();
            while (it.hasNext()) {
                sb.append(" ");
                sb.append((String)it.next());
            }
        }
        return sb.toString();
    }
}

