/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509.attr;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;

public class ObjectDigestInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    private ASN1Enumerated digestedObjectType;
    private ASN1ObjectIdentifier otherObjectTypeID;
    private AlgorithmIdentifier digestAlgorithm;
    private DERBitString objectDigest;

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public ASN1Enumerated getDigestedObjectType() {
        return this.digestedObjectType;
    }

    public DERBitString getObjectDigest() {
        return this.objectDigest;
    }

    public ASN1ObjectIdentifier getOtherObjectTypeID() {
        return this.otherObjectTypeID;
    }

    private void read() {
        if (this.getValueHolder().size() > 4 || this.getValueHolder().size() < 3) {
            throw new IllegalArgumentException("Bad sequence size: " + this.getValueHolder().size());
        }
        this.digestedObjectType = this.getValueHolder().getChild(0).toDEREnumerated();
        ASN1ValueHolder o = this.getValueHolder().getNextTyped(0, ASN1ObjectIdentifier.class);
        if (o != null) {
            this.otherObjectTypeID = o.toDERObjectIdentifier();
        }
        this.digestAlgorithm = (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(this.getValueHolder().getNextTyped(0, ASN1Sequence.class));
        this.objectDigest = this.getValueHolder().getNextTyped(0, DERBitString.class).toDERBitString();
    }

    @Override
    protected void setValueHolder(ASN1ValueHolder vh) {
        super.setValueHolder(vh);
        this.read();
    }

    public static class Factory
    extends ASN1Based.Factory<ObjectDigestInfo> {
    }
}

