/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509.attr;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.CertificateSerialNumber;
import de.intarsys.asn1.x509.Validity;
import de.intarsys.asn1.x509.attr.AttributeCertificateIssuer;
import de.intarsys.asn1.x509.attr.AttributeCertificateSubject;
import de.intarsys.asn1.x509.attr.AttributeCertificateSubjectV1;
import de.intarsys.asn1.x509.attr.AttributeCertificateSubjectV2;
import de.intarsys.asn1.x509.attr.Attributes;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.X509Extensions;

public class AttributeCertificateInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    private Version version;
    private AttributeCertificateSubject subject;
    private AttributeCertificateIssuer issuer;
    private AlgorithmIdentifier signature;
    private CertificateSerialNumber serialNumber;
    private Validity attrCertValidityPeriod;
    private Attributes attributes;
    private DERBitString issuerUniqueId;
    private X509Extensions extensions;

    public Validity getAttrCertValidityPeriod() {
        return this.attrCertValidityPeriod;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public AttributeCertificateIssuer getIssuer() {
        return this.issuer;
    }

    public DERBitString getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public CertificateSerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public AttributeCertificateSubject getSubject() {
        return this.subject;
    }

    public Version getVersion() {
        if (this.version == null) {
            return Version.create(0);
        }
        return this.version;
    }

    private void read() {
        int nextIndex = 0;
        ASN1ValueHolder o = this.getValueHolder().getChild(nextIndex);
        if (o.isTagged()) {
            this.version = null;
        } else {
            this.version = (Version)Version.FACTORY.create(o);
            ++nextIndex;
        }
        o = this.getValueHolder().getChild(nextIndex);
        this.subject = this.getVersion().getIntValue() == 0 ? (AttributeCertificateSubject)AttributeCertificateSubjectV1.FACTORY.create(o) : (AttributeCertificateSubject)AttributeCertificateSubjectV2.FACTORY.create(o);
        o = this.getValueHolder().getChild(++nextIndex);
        this.issuer = (AttributeCertificateIssuer)AttributeCertificateIssuer.FACTORY.create(o);
        o = this.getValueHolder().getChild(++nextIndex);
        this.signature = (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(o);
        o = this.getValueHolder().getChild(++nextIndex);
        this.serialNumber = (CertificateSerialNumber)CertificateSerialNumber.FACTORY.create(o);
        o = this.getValueHolder().getChild(++nextIndex);
        this.attrCertValidityPeriod = (Validity)Validity.FACTORY.create(o);
        o = this.getValueHolder().getChild(++nextIndex);
        this.attributes = (Attributes)Attributes.FACTORY.create(o);
        if (++nextIndex < this.getValueHolder().size()) {
            o = this.getValueHolder().getChild(nextIndex);
            if (ASN1Tools.isInstanceOf(o, DERBitString.class)) {
                this.issuerUniqueId = o.toDERBitString();
                ++nextIndex;
            } else {
                this.issuerUniqueId = null;
            }
        }
        if (nextIndex < this.getValueHolder().size()) {
            o = this.getValueHolder().getChild(nextIndex);
            this.extensions = X509Extensions.getInstance((Object)o.toASN1Primitive());
            ++nextIndex;
        }
    }

    @Override
    protected void setValueHolder(ASN1ValueHolder vh) {
        super.setValueHolder(vh);
        this.read();
    }

    public static class Factory
    extends ASN1Based.Factory<AttributeCertificateInfo> {
    }
}

