/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.date.DateEnvironment;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UTCTime;

public class Time
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public static Time create(Date time) {
        Time result = (Time)FACTORY.createNew();
        result.setTime(time);
        return result;
    }

    public Date getTime() {
        try {
            ASN1Primitive p = this.toASN1Primitive();
            if (p instanceof ASN1GeneralizedTime) {
                return ((ASN1GeneralizedTime)p).getDate();
            }
            if (p instanceof ASN1UTCTime) {
                return ((ASN1UTCTime)p).getDate();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public void setTime(Date time) {
        this.getValueHolder().setValue((ASN1Primitive)new ASN1GeneralizedTime(time));
    }

    public static class Factory
    extends ASN1Based.Factory<Time> {
        @Override
        protected ASN1ValueHolder basicCreateValueHolder() {
            return ASN1ValueHolder.create((ASN1Encodable)new ASN1UTCTime(DateEnvironment.get().now()));
        }
    }
}

