/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.string.PrettyPrinter;
import java.io.IOException;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;

public class RDNSequence
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public String getString() throws IOException {
        return new X500Principal(ASN1Tools.toByteArray(this)).toString();
    }

    public void setString(String s) throws IOException {
        X500Principal principal = new X500Principal(s);
        this.setValueHolder(ASN1ValueHolder.create((ASN1Encodable)ASN1Tools.create(principal.getEncoded())));
    }

    @Override
    public void toString(PrettyPrinter printer) {
        try {
            printer.appendValue((Object)this.getString());
        }
        catch (IOException e) {
            printer.appendValue((Object)"<error>");
        }
    }

    public static class Factory
    extends ASN1Based.Factory<RDNSequence> {
    }
}

