/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.policy;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.policy.AlgAndLength;
import java.util.ArrayList;
import java.util.List;

public class AlgorithmConstraintSet
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public List<AlgAndLength> getSignerAlgorithmConstraints() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(0, 0, true);
        return this.toAlgorithmConstraints(vh);
    }

    public List<AlgAndLength> getEeCertAlgorithmConstraints() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(0, 1, true);
        return this.toAlgorithmConstraints(vh);
    }

    public List<AlgAndLength> getCaCertAlgorithmConstraints() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(0, 2, true);
        return this.toAlgorithmConstraints(vh);
    }

    public List<AlgAndLength> getAaCertAlgorithmConstraints() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(0, 3, true);
        return this.toAlgorithmConstraints(vh);
    }

    public List<AlgAndLength> getTsaCertAlgorithmConstraints() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(0, 4, true);
        return this.toAlgorithmConstraints(vh);
    }

    protected List<AlgAndLength> toAlgorithmConstraints(ASN1ValueHolder vh) {
        if (vh == null) {
            return null;
        }
        ArrayList<AlgAndLength> set = new ArrayList<AlgAndLength>();
        for (int i = 0; i < vh.size(); ++i) {
            set.add((AlgAndLength)AlgAndLength.FACTORY.create(vh.getChild(i)));
        }
        return set;
    }

    public static class Factory
    extends ASN1Based.Factory<AlgorithmConstraintSet> {
    }
}

