/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.model;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ScalarHolder;
import de.intarsys.asn1.model.ASN1SequenceHolder;
import de.intarsys.asn1.model.ASN1SetHolder;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1Tools;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;

public abstract class ASN1ValueHolder
implements ASN1Encodable,
Iterable<ASN1ValueHolder> {
    private boolean changed = false;
    private ASN1Primitive value;
    private ASN1ValueHolder container;

    public static ASN1ValueHolder create(ASN1Encodable o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ASN1ValueHolder) {
            ASN1ValueHolder valueHolder = (ASN1ValueHolder)o;
            return valueHolder;
        }
        if (o instanceof ASN1Based) {
            ASN1Based asn1Based = (ASN1Based)o;
            return asn1Based.getValueHolder();
        }
        ASN1Primitive primitive = o.toASN1Primitive();
        if (primitive instanceof ASN1Sequence) {
            ASN1Sequence sequence = (ASN1Sequence)primitive;
            return new ASN1SequenceHolder(sequence);
        }
        if (primitive instanceof ASN1Set) {
            ASN1Set set = (ASN1Set)primitive;
            return new ASN1SetHolder(set);
        }
        if (primitive instanceof ASN1TaggedObject) {
            ASN1TaggedObject taggedObject = (ASN1TaggedObject)primitive;
            return new ASN1TaggedHolder(taggedObject);
        }
        return new ASN1ScalarHolder(primitive);
    }

    protected ASN1ValueHolder() {
        this.setChanged(true);
    }

    protected ASN1ValueHolder(ASN1Primitive value) {
        this.value = value;
    }

    public abstract void addChild(ASN1Encodable var1);

    protected ASN1Primitive createASN1Primitive() {
        return this.value;
    }

    public abstract ASN1ValueHolder getChild();

    public abstract ASN1ValueHolder getChild(int var1);

    public <T extends ASN1Primitive> ASN1ValueHolder getChildIfTagged(int index, int tagNo) {
        ASN1TaggedHolder tagged;
        if (index < 0 || index >= this.size()) {
            return null;
        }
        ASN1ValueHolder o = this.getChild(index);
        if (o != null && o.isTagged() && (tagged = (ASN1TaggedHolder)o).getTagNo() == tagNo) {
            return tagged;
        }
        return null;
    }

    public <T extends ASN1Primitive> ASN1ValueHolder getChildIfTyped(int index, Class<T> clazz) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        ASN1ValueHolder o = this.getChild(index);
        if (o != null && clazz.isInstance(o.toASN1Primitive())) {
            return o;
        }
        return null;
    }

    protected ASN1ValueHolder getContainer() {
        return this.container;
    }

    public ASN1ValueHolder getNextNotTagged(int start) {
        if (start < 0 || start >= this.size()) {
            return null;
        }
        for (int i = start; i < this.size(); ++i) {
            ASN1ValueHolder o = this.getChild(i);
            if (o == null || o.isTagged()) continue;
            return o;
        }
        return null;
    }

    public ASN1TaggedHolder getNextTagged(int start, int tagNo) {
        if (start < 0 || start >= this.size()) {
            return null;
        }
        for (int i = start; i < this.size(); ++i) {
            ASN1TaggedHolder tagged;
            ASN1ValueHolder o = this.getChild(i);
            if (o == null || !o.isTagged() || (tagged = (ASN1TaggedHolder)o).getTagNo() != tagNo) continue;
            return tagged;
        }
        return null;
    }

    public ASN1ValueHolder getNextTaggedGetChild(int start, int tagNo, boolean explicit) {
        ASN1TaggedHolder temp = this.getNextTagged(start, tagNo);
        if (temp != null) {
            ((ASN1ValueHolder)temp).setExplicit(explicit);
            return ((ASN1ValueHolder)temp).getChild();
        }
        return null;
    }

    public <T extends ASN1Primitive> ASN1ValueHolder getNextTyped(int start, Class<T> clazz) {
        if (start < 0 || start >= this.size()) {
            return null;
        }
        for (int i = start; i < this.size(); ++i) {
            ASN1ValueHolder o = this.getChild(i);
            if (o == null || !clazz.isInstance(o.toASN1Primitive())) continue;
            return o;
        }
        return null;
    }

    public ASN1Primitive getValue() {
        return this.value;
    }

    public abstract void insertChild(int var1, ASN1Encodable var2);

    public boolean isApplicationSpecific() {
        return false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isExplicit() {
        return false;
    }

    public boolean isScalar() {
        return false;
    }

    public boolean isSequence() {
        return false;
    }

    public boolean isSet() {
        return false;
    }

    public boolean isTagged() {
        return false;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public abstract void setChild(ASN1Encodable var1);

    public abstract void setChild(int var1, ASN1Encodable var2);

    protected void setContainer(ASN1ValueHolder container) {
        this.container = container;
    }

    public void setExplicit(boolean value) {
    }

    public void setValue(ASN1Primitive value) {
        this.setChanged(true);
        this.value = value;
    }

    public abstract int size();

    public ASN1IA5String toASN1IA5String() {
        if (this.getContainer() != null && this.getContainer().isTagged()) {
            ASN1TaggedHolder tagged = (ASN1TaggedHolder)this.getContainer();
            if (tagged.isExplicit()) {
                return ASN1IA5String.getInstance((Object)this.toASN1Primitive());
            }
            return ASN1IA5String.getInstance((ASN1TaggedObject)tagged.toASN1Primitive(), (boolean)false);
        }
        return ASN1IA5String.getInstance((Object)this.toASN1Primitive());
    }

    public ASN1Primitive toASN1Primitive() {
        if (this.isChanged()) {
            this.value = this.createASN1Primitive();
            this.setChanged(false);
        }
        return this.value;
    }

    public ASN1PrintableString toASN1PrintableString() {
        if (this.getContainer() != null && this.getContainer().isTagged()) {
            ASN1TaggedHolder tagged = (ASN1TaggedHolder)this.getContainer();
            if (tagged.isExplicit()) {
                return ASN1PrintableString.getInstance((Object)this.toASN1Primitive());
            }
            return ASN1PrintableString.getInstance((ASN1TaggedObject)tagged.toASN1Primitive(), (boolean)false);
        }
        return ASN1PrintableString.getInstance((Object)this.toASN1Primitive());
    }

    public ASN1UTF8String toASN1UTF8String() {
        if (this.getContainer() != null && this.getContainer().isTagged()) {
            ASN1TaggedHolder tagged = (ASN1TaggedHolder)this.getContainer();
            if (tagged.isExplicit()) {
                return ASN1UTF8String.getInstance((Object)this.toASN1Primitive());
            }
            return ASN1UTF8String.getInstance((ASN1TaggedObject)tagged.toASN1Primitive(), (boolean)false);
        }
        return ASN1UTF8String.getInstance((Object)this.toASN1Primitive());
    }

    public byte[] toBytes() {
        return DEROctetString.getInstance((Object)this.toASN1Primitive()).getOctets();
    }

    public DERBitString toDERBitString() {
        if (this.getContainer() != null && this.getContainer().isTagged()) {
            ASN1TaggedHolder tagged = (ASN1TaggedHolder)this.getContainer();
            if (tagged.isExplicit()) {
                return DERBitString.convert((ASN1BitString)ASN1BitString.getInstance((Object)this.toASN1Primitive()));
            }
            return DERBitString.convert((ASN1BitString)ASN1BitString.getInstance((ASN1TaggedObject)tagged.toASN1Primitive(), (boolean)false));
        }
        return DERBitString.convert((ASN1BitString)ASN1BitString.getInstance((Object)this.toASN1Primitive()));
    }

    public ASN1Boolean toDERBoolean() {
        if (this.getContainer() != null && this.getContainer().isTagged()) {
            ASN1TaggedHolder tagged = (ASN1TaggedHolder)this.getContainer();
            if (tagged.isExplicit()) {
                return ASN1Boolean.getInstance((Object)this.toASN1Primitive());
            }
            return ASN1Boolean.getInstance((ASN1TaggedObject)tagged.toASN1Primitive(), (boolean)false);
        }
        return ASN1Boolean.getInstance((Object)this.toASN1Primitive());
    }

    public ASN1Enumerated toDEREnumerated() {
        if (this.getContainer() != null && this.getContainer().isTagged()) {
            ASN1TaggedHolder tagged = (ASN1TaggedHolder)this.getContainer();
            if (tagged.isExplicit()) {
                return ASN1Enumerated.getInstance((Object)this.toASN1Primitive());
            }
            return ASN1Enumerated.getInstance((ASN1TaggedObject)tagged.toASN1Primitive(), (boolean)false);
        }
        return ASN1Enumerated.getInstance((Object)this.toASN1Primitive());
    }

    public ASN1Integer toDERInteger() {
        ASN1TaggedHolder tagged;
        if (this.getContainer() != null && this.getContainer().isTagged() && !(tagged = (ASN1TaggedHolder)this.getContainer()).isExplicit()) {
            return ASN1Integer.getInstance((ASN1TaggedObject)tagged.toASN1Primitive(), (boolean)false);
        }
        return ASN1Tools.toASN1Integer((ASN1Encodable)this.toASN1Primitive());
    }

    public ASN1ObjectIdentifier toDERObjectIdentifier() {
        if (this.getContainer() != null && this.getContainer().isTagged()) {
            ASN1TaggedHolder tagged = (ASN1TaggedHolder)this.getContainer();
            if (tagged.isExplicit()) {
                return ASN1ObjectIdentifier.getInstance((Object)this.toASN1Primitive());
            }
            return ASN1ObjectIdentifier.getInstance((ASN1TaggedObject)tagged.toASN1Primitive(), (boolean)false);
        }
        return ASN1ObjectIdentifier.getInstance((Object)this.toASN1Primitive());
    }

    public DEROctetString toDEROctetString() {
        return (DEROctetString)this.toASN1Primitive();
    }
}

