/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.model;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.IASN1Decoder;
import de.intarsys.asn1.model.IASN1Encoder;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.adapter.GenericAdapterFactory;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.PrettyPrinter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;

public class ASN1Tools {
    public static ASN1Primitive copy(ASN1Primitive object) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ASN1Tools.writeOn((OutputStream)out, new ASN1Encodable[]{object});
        out.close();
        return ASN1Tools.create(out.toByteArray());
    }

    public static ASN1Primitive create(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            ASN1Primitive aSN1Primitive = ASN1Tools.create(is);
            return aSN1Primitive;
        }
    }

    public static ASN1Primitive create(InputStream in) throws IOException {
        ASN1InputStream asn1In = new ASN1InputStream(in);
        try {
            return asn1In.readObject();
        }
        catch (IOException e) {
            if (!"unexpected end-of-contents marker".equals(e.getMessage())) {
                throw e;
            }
            return null;
        }
    }

    public static List<ASN1Primitive> createAll(byte[] data) throws IOException {
        if (data == null) {
            return Collections.emptyList();
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            List<ASN1Primitive> list = ASN1Tools.createAll(is);
            return list;
        }
    }

    public static List<ASN1Primitive> createAll(byte[][] data) throws IOException {
        ArrayList<ASN1Primitive> result = new ArrayList<ASN1Primitive>();
        if (data != null) {
            for (byte[] record : data) {
                ASN1Primitive asn1 = ASN1Tools.create(record);
                if (asn1 == null) continue;
                result.add(asn1);
            }
        }
        return result;
    }

    public static List<ASN1Primitive> createAll(InputStream in) throws IOException {
        ArrayList<ASN1Primitive> result;
        block5: {
            ASN1InputStream asn1In = new ASN1InputStream(in);
            result = new ArrayList<ASN1Primitive>();
            try {
                ASN1Primitive p = asn1In.readObject();
                while (p != null) {
                    result.add(p);
                    p = asn1In.readObject();
                }
            }
            catch (EOFException e) {
                if (!"EOF found inside tag value.".equals(e.getMessage())) {
                    throw e;
                }
            }
            catch (IOException e) {
                if ("unexpected end-of-contents marker".equals(e.getMessage())) break block5;
                throw e;
            }
        }
        return result;
    }

    public static <D> D decodeObject(ASN1Encodable asn1Object, Class<D> expectedClass) throws IOException {
        IASN1Decoder decoder = (IASN1Decoder)AdapterTools.getAdapter((Object)asn1Object, IASN1Decoder.class, null);
        if (decoder == null) {
            throw new IOException("No decoder available for object of type " + asn1Object.getClass().getName());
        }
        return decoder.decode(asn1Object);
    }

    public static <D, E extends ASN1Encodable> E encodeObject(D object) throws IOException {
        IASN1Encoder encoder = (IASN1Encoder)AdapterTools.getAdapter(object, IASN1Encoder.class, null);
        if (encoder == null) {
            throw new IOException("No encoder available for object of type " + object.getClass().getName());
        }
        return encoder.encode(object);
    }

    protected static void ensureSize(List<ASN1Encodable> objects, int size) {
        for (int i = objects.size(); i <= size; ++i) {
            objects.add(null);
        }
    }

    public static byte[] getASN1OctetStringOctets(byte[] encoded) throws IOException {
        if (encoded == null || encoded.length == 0) {
            return null;
        }
        try {
            ASN1Primitive o = ASN1Tools.create(encoded);
            return ((ASN1OctetString)o).getOctets();
        }
        catch (ClassCastException e) {
            throw new IOException("not a decodable ASN.1 OctetString");
        }
    }

    public static List<String> getBitStringFlags(byte[] bytes, String[] flags) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < flags.length; ++i) {
            if (!ASN1Tools.getBitStringValue(bytes, i)) continue;
            result.add(flags[i]);
        }
        return result;
    }

    public static boolean getBitStringValue(byte[] bytes, int index) {
        int pos = index / 8;
        int subindex = index % 8;
        if (bytes.length <= pos) {
            return false;
        }
        byte value = bytes[pos];
        byte pattern = (byte)(1 << 7 - subindex);
        return (value & pattern) != 0;
    }

    public static boolean isASN1ApplicationSpecific(ASN1Encodable asn1) {
        ASN1TaggedObject taggedObject;
        if (asn1 == null) {
            return false;
        }
        ASN1Primitive aSN1Primitive = asn1.toASN1Primitive();
        return aSN1Primitive instanceof ASN1TaggedObject && (taggedObject = (ASN1TaggedObject)aSN1Primitive).getTagClass() == 64;
    }

    public static boolean isASN1Scalar(ASN1Encodable asn1) {
        if (asn1 == null) {
            return false;
        }
        ASN1Primitive p = asn1.toASN1Primitive();
        if (ASN1Tools.isASN1Sequence((ASN1Encodable)p)) {
            return false;
        }
        if (ASN1Tools.isASN1Tagged((ASN1Encodable)p)) {
            return false;
        }
        if (ASN1Tools.isASN1Set((ASN1Encodable)p)) {
            return false;
        }
        return !ASN1Tools.isASN1ApplicationSpecific((ASN1Encodable)p);
    }

    public static boolean isASN1Sequence(ASN1Encodable asn1) {
        if (asn1 == null) {
            return false;
        }
        return asn1.toASN1Primitive() instanceof ASN1Sequence;
    }

    public static boolean isASN1Set(ASN1Encodable asn1) {
        if (asn1 == null) {
            return false;
        }
        return asn1.toASN1Primitive() instanceof ASN1Set;
    }

    public static boolean isASN1Tagged(ASN1Encodable asn1) {
        if (asn1 == null) {
            return false;
        }
        return asn1.toASN1Primitive() instanceof ASN1TaggedObject;
    }

    public static boolean isInstanceOf(ASN1Encodable asn1, Class clazz) {
        if (asn1 == null) {
            return false;
        }
        return clazz.isInstance(asn1.toASN1Primitive());
    }

    public static void printBitStringFlags(PrettyPrinter printer, byte[] bytes, String[] flags) {
        boolean needSeparator = false;
        printer.appendString("[");
        printer.appendString(HexTools.bytesToHexString((byte[])bytes));
        printer.appendString("] - ");
        for (int i = 0; i < flags.length; ++i) {
            if (!ASN1Tools.getBitStringValue(bytes, i)) continue;
            if (needSeparator) {
                printer.appendString(", ");
            }
            printer.appendString(flags[i]);
            needSeparator = true;
        }
    }

    public static void printBitStringFlags(Writer w, byte[] bytes, String[] flags) throws IOException {
        boolean needSeparator = false;
        for (int i = 0; i < flags.length; ++i) {
            if (!ASN1Tools.getBitStringValue(bytes, i)) continue;
            if (needSeparator) {
                w.write(", ");
            }
            w.write(flags[i]);
            needSeparator = true;
        }
    }

    public static void registerDecoder(Class<?> objectClass, IASN1Decoder decoder) {
        GenericAdapterFactory adapterFactory = new GenericAdapterFactory(objectClass, IASN1Decoder.class, (Object)decoder);
        adapterFactory.register();
    }

    public static void registerEncoder(Class<?> objectClass, IASN1Encoder encoder) {
        GenericAdapterFactory adapterFactory = new GenericAdapterFactory(objectClass, IASN1Encoder.class, (Object)encoder);
        adapterFactory.register();
    }

    public static ASN1Integer toASN1Integer(ASN1Encodable encodable) {
        if (encodable == null) {
            return null;
        }
        ASN1Primitive p = encodable.toASN1Primitive();
        if (p instanceof ASN1Integer) {
            return (ASN1Integer)p;
        }
        if (p instanceof ASN1OctetString) {
            return new ASN1Integer(new BigInteger(((ASN1OctetString)p).getOctets()));
        }
        if (p instanceof ASN1Enumerated) {
            return new ASN1Integer(((ASN1Enumerated)p).getValue());
        }
        return null;
    }

    public static ASN1ObjectIdentifier toASN1ObjectIdentifier(ASN1Encodable encodable) {
        if (encodable == null) {
            return null;
        }
        ASN1Primitive p = encodable.toASN1Primitive();
        if (p instanceof ASN1ObjectIdentifier) {
            return ASN1ObjectIdentifier.getInstance((Object)p);
        }
        return null;
    }

    public static ASN1OctetString toASN1OctetString(ASN1Encodable encodable) {
        if (encodable == null) {
            return null;
        }
        ASN1Primitive p = encodable.toASN1Primitive();
        if (p instanceof ASN1OctetString) {
            return (ASN1OctetString)p;
        }
        if (p instanceof ASN1Integer) {
            return new DEROctetString(((ASN1Integer)p).getValue().toByteArray());
        }
        return null;
    }

    public static byte[] toByteArray(ASN1Encodable ... objects) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ASN1Tools.writeOn((OutputStream)bos, objects);
        return bos.toByteArray();
    }

    public static byte[] toByteArray(List<ASN1Encodable> objects) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ASN1Tools.writeOn((OutputStream)bos, objects);
        return bos.toByteArray();
    }

    public static boolean toStringPrimitive(PrettyPrinter printer, Object value) {
        if (value instanceof ASN1Based) {
            return false;
        }
        if (value instanceof ASN1Encodable) {
            ASN1Primitive primitive = ((ASN1Encodable)value).toASN1Primitive();
            if (primitive instanceof ASN1Null) {
                printer.appendString("NULL");
            } else if (primitive instanceof ASN1OctetString) {
                printer.appendString(HexTools.bytesToHexString((byte[])((ASN1OctetString)primitive).getOctets()));
            } else if (primitive instanceof ASN1String) {
                printer.appendString(((ASN1String)primitive).getString());
            } else if (primitive instanceof ASN1Boolean) {
                printer.appendString(((ASN1Boolean)primitive).toString());
            } else if (primitive instanceof ASN1ObjectIdentifier) {
                printer.appendString(((ASN1ObjectIdentifier)primitive).getId());
            } else if (primitive instanceof ASN1Integer) {
                printer.appendString(String.valueOf(((ASN1Integer)primitive).getValue()));
            } else if (primitive instanceof ASN1TaggedObject) {
                ASN1TaggedObject taggedObject = (ASN1TaggedObject)primitive;
                printer.appendString(String.valueOf(taggedObject.getTagNo()));
                printer.appendString("-");
                printer.appendString(String.valueOf(taggedObject.getBaseObject().toASN1Primitive()));
            } else if (primitive instanceof ASN1Sequence) {
                Enumeration e = ((ASN1Sequence)primitive).getObjects();
                int i = 0;
                while (e.hasMoreElements()) {
                    ASN1Encodable child = (ASN1Encodable)e.nextElement();
                    printer.appendMember("" + i, (Object)child, null);
                    ++i;
                }
            } else if (primitive instanceof ASN1Set) {
                Enumeration e = ((ASN1Set)primitive).getObjects();
                int i = 0;
                while (e.hasMoreElements()) {
                    ASN1Encodable child = (ASN1Encodable)e.nextElement();
                    printer.appendMember("" + i, (Object)child, null);
                    ++i;
                }
            } else {
                printer.appendString("[");
                try {
                    printer.appendString(HexTools.bytesToHexString((byte[])primitive.getEncoded()));
                }
                catch (IOException e) {
                    printer.appendString("<error>");
                }
                printer.appendString("]");
            }
            return true;
        }
        return false;
    }

    public static void writeOn(OutputStream os, ASN1Encodable ... objects) throws IOException {
        for (ASN1Encodable o : objects) {
            if (o == null) continue;
            ASN1OutputStream asn1Out = ASN1OutputStream.create((OutputStream)os, (String)"DER");
            asn1Out.writeObject(o);
            asn1Out.flush();
        }
    }

    public static void writeOn(OutputStream os, List<ASN1Encodable> objects) throws IOException {
        for (ASN1Encodable o : objects) {
            if (o == null) continue;
            ASN1OutputStream asn1Out = ASN1OutputStream.create((OutputStream)os, (String)"DER");
            asn1Out.writeObject(o);
            asn1Out.flush();
        }
    }
}

