/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.model;

import de.intarsys.asn1.model.ASN1SequenceHolder;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.IPrettyPrintable;
import de.intarsys.tools.string.IPrettyPrinterPrimitive;
import de.intarsys.tools.string.PrettyPrinter;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;

public abstract class ASN1Based
implements ASN1Encodable,
IPrettyPrintable,
IPrettyPrinterPrimitive {
    private ASN1ValueHolder valueHolder;

    protected ASN1Based() {
    }

    protected ASN1Primitive basicCopy() throws IOException {
        return ASN1Tools.copy(this.toASN1Primitive());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.toASN1Primitive().equals(obj);
    }

    protected String getClassName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public byte[] getDEREncoded() throws IOException {
        return ASN1Tools.toByteArray(this);
    }

    public ASN1ValueHolder getValueHolder() {
        return this.valueHolder;
    }

    protected void initializeAfterCreate() {
    }

    protected void initializeAfterCreateNew() {
    }

    public boolean isChanged() {
        return this.getValueHolder().isChanged();
    }

    protected void setValueHolder(ASN1ValueHolder valueHolder) {
        if (valueHolder == null) {
            throw new IllegalArgumentException();
        }
        this.valueHolder = valueHolder;
    }

    public int size() {
        return this.getValueHolder().size();
    }

    public ASN1Primitive toASN1Primitive() {
        return this.getValueHolder().toASN1Primitive();
    }

    public final String toString() {
        return new PrettyPrinter().toString((Object)this);
    }

    public void toString(PrettyPrinter printer) {
        printer.appendValue((Object)this.getValueHolder().toASN1Primitive());
    }

    public boolean toString(PrettyPrinter printer, Object value) {
        return ASN1Tools.toStringPrimitive(printer, value);
    }

    public static class Factory<T extends ASN1Based> {
        private Class<T> instanceClass = this.getClass().getDeclaringClass();

        protected Factory() {
        }

        protected T basicCreate(ASN1Encodable asn1) throws ObjectCreationException {
            ASN1Based result = (ASN1Based)ObjectTools.createObject(this.getInstanceClass(), this.getInstanceClass());
            ASN1ValueHolder vh = this.basicCreateValueHolder(asn1);
            vh.setExplicit(this.isExplicit());
            result.setValueHolder(vh);
            return (T)result;
        }

        protected T basicCreateNew() throws ObjectCreationException {
            ASN1Based result = (ASN1Based)ObjectTools.createObject(this.getInstanceClass(), this.getInstanceClass());
            ASN1ValueHolder vh = this.basicCreateValueHolder();
            vh.setExplicit(this.isExplicit());
            result.setValueHolder(vh);
            return (T)result;
        }

        protected ASN1ValueHolder basicCreateValueHolder() {
            return new ASN1SequenceHolder();
        }

        protected ASN1ValueHolder basicCreateValueHolder(ASN1Encodable asn1) {
            return ASN1ValueHolder.create(asn1);
        }

        public final T create(ASN1Encodable asn1) {
            try {
                Factory<T> subtypeFactory = this.selectSubtypeFactory(asn1);
                if (subtypeFactory != null && subtypeFactory != this) {
                    return subtypeFactory.create(asn1);
                }
                if (asn1 == null) {
                    return this.createFromNull();
                }
                T result = this.basicCreate(asn1);
                ((ASN1Based)result).initializeAfterCreate();
                return result;
            }
            catch (ObjectCreationException e) {
                throw new IllegalArgumentException(e);
            }
        }

        protected T createFromNull() {
            return null;
        }

        public final T createNew() {
            try {
                T result = this.basicCreateNew();
                ((ASN1Based)result).initializeAfterCreateNew();
                return result;
            }
            catch (ObjectCreationException e) {
                throw new IllegalArgumentException(e);
            }
        }

        protected Class<T> getInstanceClass() {
            if (this.instanceClass == null) {
                return this.getClass().getDeclaringClass();
            }
            return this.instanceClass;
        }

        public boolean isExplicit() {
            return true;
        }

        protected Factory<T> selectSubtypeFactory(ASN1Encodable o) throws ObjectCreationException {
            return this;
        }
    }
}

