/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.ers;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.ers.ArchiveTimeStampSequence;
import de.intarsys.asn1.ers.CryptoInfos;
import de.intarsys.asn1.ers.EncryptionInfo;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1SequenceHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;

public class EvidenceRecord
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public ArchiveTimeStampSequence getArchiveTimeStampSequence() {
        ASN1ValueHolder value = this.getValueHolder().getNextNotTagged(2);
        return (ArchiveTimeStampSequence)ArchiveTimeStampSequence.FACTORY.create(value);
    }

    public CryptoInfos getCryptoInfos() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(2, 0, false);
        return (CryptoInfos)CryptoInfos.FACTORY.create(value);
    }

    public AlgorithmIdentifier[] getDigestAlgorithms() {
        ASN1SequenceHolder algorithmSequence = (ASN1SequenceHolder)this.getValueHolder().getChild(1);
        AlgorithmIdentifier[] digestAlgorithms = new AlgorithmIdentifier[algorithmSequence.size()];
        for (int i = 0; i < digestAlgorithms.length; ++i) {
            digestAlgorithms[i] = (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(algorithmSequence.getChild(i));
        }
        return digestAlgorithms;
    }

    public EncryptionInfo getEncryptionInfo() {
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(2, 1, false);
        return (EncryptionInfo)EncryptionInfo.FACTORY.create(value);
    }

    public int getVersion() {
        return this.getValueHolder().getChild(0).toDERInteger().getValue().intValue();
    }

    public static class Factory
    extends ASN1Based.Factory<EvidenceRecord> {
    }
}

