/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.attr.IssuerSerial;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;

public class ESSCertID
extends ASN1Based {
    public static final String OID_SHA1 = "1.3.14.3.2.26";
    public static final Factory<ESSCertID> FACTORY = new Factory();

    protected boolean containsHashAlgorithm() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        if (o == null) {
            return false;
        }
        return o.isSequence();
    }

    protected String defaultHashAlgorithmOID() {
        return OID_SHA1;
    }

    public byte[] getCertHash() {
        DEROctetString hash = this.getValueHolder().getNextTyped(0, DEROctetString.class).toDEROctetString();
        return hash.getOctets();
    }

    public String getHashAlgorithmOID() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        if (!o.isSequence()) {
            return this.defaultHashAlgorithmOID();
        }
        return ((AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(o)).getAlgorithm();
    }

    public IssuerSerial getIssuerSerial() {
        return (IssuerSerial)IssuerSerial.FACTORY.create(this.getValueHolder().getNextTyped(1, ASN1Sequence.class));
    }

    protected int indexCertHash() {
        if (this.containsHashAlgorithm()) {
            return 1;
        }
        return 0;
    }

    protected int indexHashAlgorithm() {
        return 0;
    }

    protected int indexIssuerSerial() {
        if (this.containsHashAlgorithm()) {
            return 2;
        }
        return 1;
    }

    public void setCertHash(byte[] hash) {
        this.getValueHolder().setChild(this.indexCertHash(), (ASN1Encodable)new DEROctetString(hash));
    }

    public void setIssuerSerial(IssuerSerial issuerSerial) {
        this.getValueHolder().setChild(this.indexIssuerSerial(), issuerSerial);
    }

    public static class Factory<T extends ESSCertID>
    extends ASN1Based.Factory<T> {
    }
}

