/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.cms.ContentType;
import de.intarsys.asn1.common.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class AttributeContentType
extends Attribute {
    public static final String ID = PKCSObjectIdentifiers.pkcs_9 + ".3";
    public static final Factory FACTORY = new Factory();

    public static AttributeContentType create(ContentType contentType) {
        AttributeContentType result = (AttributeContentType)FACTORY.createNew();
        result.setContentType(contentType);
        return result;
    }

    public ContentType getContentType() {
        return (ContentType)ContentType.FACTORY.create(this.getAttrValue(0));
    }

    @Override
    protected void initializeAfterCreateNew() {
        super.initializeAfterCreateNew();
        this.setAttrType(ID);
    }

    public void setContentType(ContentType contentType) {
        this.setAttrValue(0, contentType);
    }

    public static class Factory
    extends Attribute.Factory<AttributeContentType> {
        @Override
        public String getAttributeType() {
            return ID;
        }
    }
}

