/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.attr.AttributeCertificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AttributeAttributeCertificates
extends Attribute {
    public static final String ID = "2.5.4.58";
    public static final Factory FACTORY = new Factory();

    public void addAttributeCertificate(AttributeCertificate attrCert) {
        this.addAttrValue(attrCert);
    }

    public List<AttributeCertificate> getAttributeCertificates() {
        ASN1ValueHolder values = this.getAttrValues();
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<AttributeCertificate> result = new ArrayList<AttributeCertificate>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            ASN1ValueHolder obj = values.getChild(i);
            AttributeCertificate attrCertificate = (AttributeCertificate)AttributeCertificate.FACTORY.create(obj);
            result.add(attrCertificate);
        }
        return result;
    }

    @Override
    protected void initializeAfterCreateNew() {
        super.initializeAfterCreateNew();
        this.setAttrType(ID);
    }

    public void setAttributeCertificates(List<AttributeCertificate> attrCerts) {
        this.clearAttrValue();
        for (AttributeCertificate cert : attrCerts) {
            this.addAttributeCertificate(cert);
        }
    }

    public static class Factory
    extends Attribute.Factory<AttributeAttributeCertificates> {
        @Override
        public String getAttributeType() {
            return AttributeAttributeCertificates.ID;
        }
    }
}

