/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.ContentEncryptionAlgorithmIdentifier;
import de.intarsys.asn1.cms.ContentType;
import de.intarsys.asn1.cms.EncryptedContent;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;

public class EncryptedContentInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public EncryptedContentInfo copy() throws IOException {
        return (EncryptedContentInfo)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public ContentEncryptionAlgorithmIdentifier getContentEncryptionAlgorithmIdentifier() {
        return (ContentEncryptionAlgorithmIdentifier)ContentEncryptionAlgorithmIdentifier.FACTORY.create(this.getValueHolder().getChild(1));
    }

    public ContentType getContentType() {
        return (ContentType)ContentType.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public EncryptedContent getEncryptedContent() {
        ASN1ValueHolder obj = this.getValueHolder().getNextTaggedGetChild(2, 0, false);
        if (obj == null) {
            return null;
        }
        if (obj.isSequence() && obj.size() == 1) {
            obj = obj.getChild(0);
        }
        return (EncryptedContent)EncryptedContent.FACTORY.create(obj);
    }

    public void setContentEncryptionAlgorithmIdentifier(ContentEncryptionAlgorithmIdentifier contentEncAlgId) {
        this.getValueHolder().setChild(1, contentEncAlgId);
    }

    public void setContentType(ContentType contentType) {
        this.getValueHolder().setChild(0, contentType);
    }

    public void setEncryptedContent(EncryptedContent encryptedContent) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(false, 0, encryptedContent);
        this.getValueHolder().setChild(2, tagged);
    }

    public static class Factory
    extends ASN1Based.Factory<EncryptedContentInfo> {
    }
}

