/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.Data;
import de.intarsys.asn1.cms.DigestedData;
import de.intarsys.asn1.cms.EncryptedData;
import de.intarsys.asn1.cms.EnvelopedData;
import de.intarsys.asn1.cms.SignedAndEnvelopedData;
import de.intarsys.asn1.cms.SignedData;
import de.intarsys.asn1.cms.UnknownContent;
import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1Based;
import java.io.IOException;

public abstract class CMSContent
extends ASN1Based {
    static final String OID_data = "1.2.840.113549.1.7.1";
    static final String OID_signedData = "1.2.840.113549.1.7.2";
    static final String OID_envelopedData = "1.2.840.113549.1.7.3";
    static final String OID_signedAndEnvelopedData = "1.2.840.113549.1.7.4";
    static final String OID_digestedData = "1.2.840.113549.1.7.5";
    static final String OID_encryptedData = "1.2.840.113549.1.7.6";

    public static Factory findFactory(String protocol) {
        Factory[] factories;
        for (Factory factory : factories = new Factory[]{Data.FACTORY, DigestedData.FACTORY, EncryptedData.FACTORY, EnvelopedData.FACTORY, SignedAndEnvelopedData.FACTORY, SignedData.FACTORY}) {
            if (!factory.isFactoryFor(protocol)) continue;
            return factory;
        }
        return UnknownContent.FACTORY;
    }

    public byte[] getBytes() throws IOException {
        return this.getDEREncoded();
    }

    public Version getVersion() {
        return (Version)Version.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public void setVersion(Version version) {
        this.getValueHolder().setChild(0, version);
    }

    public static class Factory<T extends CMSContent>
    extends ASN1Based.Factory<T> {
        public boolean isFactoryFor(String oid) {
            return false;
        }
    }
}

