/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.suis.validator.rest.to.response;

import ch.admin.suis.validator.rest.to.StatusUtil;
import ch.admin.suis.validator.rest.to.ValidStatus;
import ch.admin.suis.validator.rest.to.response.FileReport;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@XmlRootElement
public class ValidationResponse {
    private String error;
    private List<FileReport> fileReports;
    private String pdfOutputFileName;
    private byte[] pdfReport;

    public String getError() {
        return this.error;
    }

    public List<FileReport> getFileReports() {
        if (this.fileReports == null) {
            this.fileReports = new ArrayList<FileReport>();
        }
        return this.fileReports;
    }

    public String getPdfOutputFileName() {
        return this.pdfOutputFileName;
    }

    public byte[] getPdfReport() {
        return this.pdfReport;
    }

    public ValidStatus isValid() {
        List<FileReport> reports = this.getFileReports();
        ValidStatus state = StatusUtil.initStatus(reports);
        for (FileReport fileRep : reports) {
            state = StatusUtil.updateStatus(state, fileRep.isValid());
        }
        return state;
    }

    public ValidStatus isValidCert() {
        List<FileReport> reports = this.getFileReports();
        ValidStatus state = StatusUtil.initStatus(reports);
        for (FileReport fileRep : reports) {
            state = StatusUtil.updateStatus(state, fileRep.isValidCert());
        }
        return state;
    }

    public ValidStatus isValidMandant() {
        List<FileReport> reports = this.getFileReports();
        ValidStatus state = StatusUtil.initStatus(reports);
        for (FileReport fileRep : reports) {
            state = StatusUtil.updateStatus(state, fileRep.isValidMandant());
        }
        return state;
    }

    public ValidStatus isValidRevoc() {
        List<FileReport> reports = this.getFileReports();
        ValidStatus state = StatusUtil.initStatus(reports);
        for (FileReport fileRep : reports) {
            state = StatusUtil.updateStatus(state, fileRep.isValidRevoc());
        }
        return state;
    }

    public ValidStatus isValidSig() {
        List<FileReport> reports = this.getFileReports();
        ValidStatus state = StatusUtil.initStatus(reports);
        for (FileReport fileRep : reports) {
            state = StatusUtil.updateStatus(state, fileRep.isValidSig());
        }
        return state;
    }

    public ValidStatus isValidTimestamp() {
        List<FileReport> reports = this.getFileReports();
        ValidStatus state = StatusUtil.initStatus(reports);
        for (FileReport fileRep : reports) {
            state = StatusUtil.updateStatus(state, fileRep.isValidTimestamp());
        }
        return state;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setFileReports(List<FileReport> fileReports) {
        this.fileReports = fileReports;
    }

    public void setPdfOutputFileName(String pdfOutputFileName) {
        this.pdfOutputFileName = pdfOutputFileName;
    }

    public void setPdfReport(byte[] pdfReport) {
        this.pdfReport = (byte[])(pdfReport != null ? Arrays.copyOf(pdfReport, pdfReport.length) : null);
    }

    public String toString() {
        return "ValidationResponse errors=" + this.error + ", pdf file name=" + this.pdfOutputFileName;
    }
}

