/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.suis.client.core.service;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FactoryFinder {
    private static Logger Log = LoggerFactory.getLogger(FactoryFinder.class);

    FactoryFinder() {
    }

    static <T> T find(String factoryId, Class<T> service) throws ClassNotFoundException {
        ServiceLoader<T> serviceLoader;
        Iterator<T> iterator;
        String className = System.getProperty(factoryId);
        if (className != null) {
            try {
                return FactoryFinder.newInstance(className);
            }
            catch (ClassNotFoundException ex) {
                Log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if ((iterator = (serviceLoader = ServiceLoader.load(service)).iterator()).hasNext()) {
            return iterator.next();
        }
        throw new ClassNotFoundException("no implementation found for " + factoryId);
    }

    private static <T> T newInstance(String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        try {
            return (T)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(ex.getMessage(), ex);
        }
    }
}

