/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.extension.runtime;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.tools.factory.DeferredFactory;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class FactoryInstaller
extends ExtensionPointHandlerAdapter {
    private static final Logger Log = LoggerFactory.getLogger(FactoryInstaller.class);
    public static final String XE_FACTORY = "factory";

    @Override
    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_FACTORY.equals(element.getName())) {
            try {
                boolean lazy = ElementTools.getBool((IElement)element, (String)"lazy", (boolean)false);
                Object factory = lazy ? new DeferredFactory((Object)extension.getProvider(), element) : (IFactory)ElementTools.createObject((IElement)element, IFactory.class, (Object)extension.getProvider(), (IArgs)Args.create());
                Outlet.get().registerFactory(factory.getId(), (IFactory)factory);
                Iterator it = element.elementIterator("alias");
                while (it.hasNext()) {
                    IElement aliasElement = (IElement)it.next();
                    String aliasId = aliasElement.attributeValue("id", null);
                    Outlet.get().registerFactory(aliasId, (IFactory)factory);
                }
            }
            catch (ObjectCreationException e) {
                String msg = "error creating factory";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        return null;
    }

    @Override
    protected void basicUninstall() {
        Outlet.get().clear();
        super.basicUninstall();
    }
}

