/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.xmp;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.method.pdf.signature.IPDDocumentSigner;
import de.intarsys.security.method.pdf.signature.ISignatureModifier;
import de.intarsys.security.method.pdf.xmp.GenericXMPMetadata;
import de.intarsys.security.method.pdf.xmp.MetadataTools;
import de.intarsys.security.method.pdf.xmp.XMPSchemaSignature;
import java.io.IOException;
import org.w3c.dom.Document;

public class XMPSignatureModifier
implements ISignatureModifier {
    private byte[] signatureData;
    private boolean pdfaCompliant;

    public byte[] getSignatureData() {
        return this.signatureData;
    }

    public void setSignatureData(byte[] signatureData) {
        this.signatureData = signatureData;
    }

    public boolean isPdfaCompliant() {
        return this.pdfaCompliant;
    }

    public void setPdfaCompliant(boolean pdfaCompliant) {
        this.pdfaCompliant = pdfaCompliant;
    }

    @Override
    public void modify(IPDDocumentSigner pdDocumentSigner, PDSignature signature) throws SecurityApplicationException {
        try {
            Document metadata = MetadataTools.getMetadataAsDocument((COSBasedObject)signature);
            GenericXMPMetadata xmp = GenericXMPMetadata.from(metadata).withPdfaSchemas().withSchema("http://intarsys.de/signature/1.0", XMPSchemaSignature.class).build();
            XMPSchemaSignature signatureSchema = xmp.getOrCreateSchema(XMPSchemaSignature.class);
            signatureSchema.setSignatureData(this.signatureData);
            if (this.pdfaCompliant && !signatureSchema.isExtensionSchemaDefinedIn(xmp)) {
                signatureSchema.addExtensionSchemaTo(xmp);
            }
            MetadataTools.setMetadata((COSBasedObject)signature, xmp.getXMPDocument());
        }
        catch (IOException exception) {
            throw new SecurityApplicationException("Failed to add XMP metadata to signature", (Throwable)exception);
        }
    }
}

