/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDCSCalGray;
import de.intarsys.pdf.pd.PDCSCalRGB;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceN;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDCSLab;
import de.intarsys.pdf.pd.PDCSPattern;
import de.intarsys.pdf.pd.PDCSSeparation;
import de.intarsys.pdf.pd.PDObject;

public abstract class PDColorSpace
extends PDObject {
    public static final COSName CN_CS_CalGray = COSName.constant("CalGray");
    public static final COSName CN_CS_CalRGB = COSName.constant("CalRGB");
    public static final COSName CN_CS_CMYK = COSName.constant("CMYK");
    public static final COSName CN_CS_DeviceCMYK = COSName.constant("DeviceCMYK");
    public static final COSName CN_CS_DeviceGray = COSName.constant("DeviceGray");
    public static final COSName CN_CS_DeviceN = COSName.constant("DeviceN");
    public static final COSName CN_CS_DeviceRGB = COSName.constant("DeviceRGB");
    public static final COSName CN_CS_DefaultGray = COSName.constant("DefaultGray");
    public static final COSName CN_CS_DefaultCMYK = COSName.constant("DefaultCMYK");
    public static final COSName CN_CS_DefaultRGB = COSName.constant("DefaultRGB");
    public static final COSName CN_CS_G = COSName.constant("G");
    public static final COSName CN_CS_ICCBased = COSName.constant("ICCBased");
    public static final COSName CN_CS_Indexed = COSName.constant("Indexed");
    public static final COSName CN_CS_I = COSName.constant("I");
    public static final COSName CN_CS_Lab = COSName.constant("Lab");
    public static final COSName CN_CS_Pattern = COSName.constant("Pattern");
    public static final COSName CN_CS_RGB = COSName.constant("RGB");
    public static final COSName CN_CS_Separation = COSName.constant("Separation");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    public static PDColorSpace getNamed(COSName name) {
        if (name.equals(CN_CS_Pattern)) {
            return new PDCSPattern(name);
        }
        return PDColorSpace.getSingleton(name);
    }

    public static PDColorSpace getSingleton(COSName name) {
        if (CN_CS_DeviceGray.equals(name)) {
            return PDCSDeviceGray.SINGLETON;
        }
        if (CN_CS_G.equals(name)) {
            return PDCSDeviceGray.SINGLETON;
        }
        if (CN_CS_DeviceRGB.equals(name)) {
            return PDCSDeviceRGB.SINGLETON;
        }
        if (CN_CS_RGB.equals(name)) {
            return PDCSDeviceRGB.SINGLETON;
        }
        if (CN_CS_DeviceCMYK.equals(name)) {
            return PDCSDeviceCMYK.SINGLETON;
        }
        if (CN_CS_CMYK.equals(name)) {
            return PDCSDeviceCMYK.SINGLETON;
        }
        return null;
    }

    protected PDColorSpace(COSObject object) {
        super(object);
    }

    public abstract int getNumComponents();

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class paramInstanceClass) {
            super(paramInstanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            if (object instanceof COSName) {
                return PDColorSpace.getNamed((COSName)object);
            }
            if (object instanceof COSArray) {
                COSArray array = (COSArray)object;
                COSName type = array.get(0).asName();
                if (type == null) {
                    throw new IllegalArgumentException("ColorSpace array has no type");
                }
                if (type.equals(CN_CS_DeviceCMYK) || type.equals(CN_CS_CMYK)) {
                    return PDCSDeviceCMYK.SINGLETON;
                }
                if (type.equals(CN_CS_DeviceRGB) || type.equals(CN_CS_RGB)) {
                    return PDCSDeviceRGB.SINGLETON;
                }
                if (type.equals(CN_CS_DeviceGray) || type.equals(CN_CS_G)) {
                    return PDCSDeviceGray.SINGLETON;
                }
            }
            return this.doCreateCOSBasedObjectBasic(object);
        }

        public COSBasedObject doCreateCOSBasedObjectBasic(COSObject object) {
            return null;
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            if (object instanceof COSStream) {
                return PDCSICCBased.META;
            }
            if (object instanceof COSArray) {
                COSName type = ((COSArray)object).get(0).asName();
                if (type == null) {
                    throw new IllegalArgumentException("ColorSpace array has no type");
                }
                if (type.equals(CN_CS_CalGray)) {
                    return PDCSCalGray.META;
                }
                if (type.equals(CN_CS_CalRGB)) {
                    return PDCSCalRGB.META;
                }
                if (type.equals(CN_CS_Lab)) {
                    return PDCSLab.META;
                }
                if (type.equals(CN_CS_ICCBased)) {
                    return PDCSICCBased.META;
                }
                if (type.equals(CN_CS_Indexed) || type.equals(CN_CS_I)) {
                    return PDCSIndexed.META;
                }
                if (type.equals(CN_CS_Pattern)) {
                    return PDCSPattern.META;
                }
                if (type.equals(CN_CS_Separation)) {
                    return PDCSSeparation.META;
                }
                if (type.equals(CN_CS_DeviceN)) {
                    return PDCSDeviceN.META;
                }
            }
            return super.doDetermineClass(object);
        }

        @Override
        public Class<PDColorSpace> getRootClass() {
            return PDColorSpace.class;
        }
    }
}

