/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.table;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.table.ITableRecord;
import de.intarsys.tools.table.TableColumnFunction;
import de.intarsys.tools.table.TableProcessingException;
import de.intarsys.tools.table.TableRecordResolver;

public class TableColumnResolverFunction
extends TableColumnFunction {
    private static final String ATTR_EXPRESSION = "expression";
    private IStringEvaluator resolver = ExpressionEvaluator.get((Mode)Mode.UNTRUSTED);
    private String expression;

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setExpression(ElementTools.getString((IElement)element, (String)ATTR_EXPRESSION, (String)this.getExpression()));
    }

    @Override
    public String getContent() {
        return this.getExpression();
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getLabel() {
        return this.getExpression();
    }

    @Override
    public Object process(ITableRecord event) throws TableProcessingException {
        Object value;
        Args args = Args.create();
        args.put("record", (Object)new TableRecordResolver(event));
        try {
            value = this.resolver.evaluate(this.getExpression(), (IArgs)args);
        }
        catch (EvaluationException e) {
            value = "<" + this.getExpression() + ">";
        }
        return value;
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        element.setAttributeValue(ATTR_EXPRESSION, this.getExpression());
    }

    @Override
    public void setContent(String content) {
        this.setExpression(content);
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }
}

