/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.standard;

import de.intarsys.security.algorithm.common.EncryptionAlgorithm;
import de.intarsys.tools.crypto.api.ICipherFactory;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.crypto.standard.SecretKeyParameter;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JcaCipherFactory
implements ICipherFactory {
    private static final int DEFAULT_KEY_SIZE = 16;
    private static final int DEFAULT_BLOCK_SIZE = 16;
    public static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    public static final String AES_CTR_NO_PADDING = "AES/CTR/NoPadding";
    public static final String DEFAULT_ENCRYPTION_ALGORITHM_TRANSFORMATION = "AES/CTR/NoPadding";
    private String encryptionAlgorithmTransformation;
    private int keySize = 16;
    private int blockSize = 16;

    public JcaCipherFactory() {
        this.setEncryptionAlgorithmTransformation("AES/CTR/NoPadding");
    }

    public JcaCipherFactory(String encryptionAlgorithmTransformation, int keySize) {
        this.setEncryptionAlgorithmTransformation(encryptionAlgorithmTransformation);
        this.setKeySize(keySize);
    }

    @Override
    public Cipher createDecipher(ICipherParameter param) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.getEncryptionAlgorithmTransformation());
        AlgorithmParameterSpec params = this.createParams(cipher, param);
        SecretKey key = this.createKey(param);
        if (params == null) {
            cipher.init(2, key);
        } else {
            cipher.init(2, (Key)key, params);
        }
        return cipher;
    }

    @Override
    public Cipher createEncipher(ICipherParameter param) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.getEncryptionAlgorithmTransformation());
        AlgorithmParameterSpec params = this.createParams(cipher, param);
        if (params == null) {
            cipher.init(1, this.createKey(param));
        } else {
            cipher.init(1, (Key)this.createKey(param), params);
        }
        return cipher;
    }

    protected SecretKey createKey(ICipherParameter param) throws GeneralSecurityException {
        if (!(param instanceof SecretKeyParameter)) {
            throw new InvalidKeyException("SecretKeyParameter required");
        }
        byte[] keyMaterial = ((SecretKeyParameter)param).getKey();
        return new SecretKeySpec(keyMaterial, EncryptionAlgorithm.getEncryptionAlgorithmName(this.getEncryptionAlgorithmTransformation()));
    }

    protected AlgorithmParameterSpec createParams(Cipher cipher, ICipherParameter param) {
        if (cipher.getAlgorithm().contains("/GCM")) {
            if (param instanceof SecretKeyParameter && ((SecretKeyParameter)param).getIv() != null && ((SecretKeyParameter)param).getIv().length != 0) {
                byte[] tmpIv = (byte[])((SecretKeyParameter)param).getIv().clone();
                return new GCMParameterSpec(128, tmpIv);
            }
        } else if (param instanceof SecretKeyParameter && ((SecretKeyParameter)param).getIv() != null && ((SecretKeyParameter)param).getIv().length != 0) {
            byte[] tmpIv = (byte[])((SecretKeyParameter)param).getIv().clone();
            return new IvParameterSpec(tmpIv);
        }
        return null;
    }

    @Override
    public Cipher createUnwrap(ICipherParameter param) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.getEncryptionAlgorithmTransformation());
        AlgorithmParameterSpec params = this.createParams(cipher, param);
        if (params == null) {
            cipher.init(4, this.createKey(param));
        } else {
            cipher.init(4, (Key)this.createKey(param), params);
        }
        return cipher;
    }

    @Override
    public Cipher createWrap(ICipherParameter param) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.getEncryptionAlgorithmTransformation());
        AlgorithmParameterSpec params = this.createParams(cipher, param);
        if (params == null) {
            cipher.init(3, this.createKey(param));
        } else {
            cipher.init(3, (Key)this.createKey(param), params);
        }
        return cipher;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public String getEncryptionAlgorithmTransformation() {
        return this.encryptionAlgorithmTransformation;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @PostConstruct
    public void init() {
        if (StringTools.isEmpty((String)this.encryptionAlgorithmTransformation)) {
            throw new IllegalArgumentException("encryptionAlgorithmTransformation required");
        }
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void setEncryptionAlgorithmTransformation(String encryptionAlgorithm) {
        this.encryptionAlgorithmTransformation = encryptionAlgorithm;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }
}

