/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.standard;

import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.ICipherFactory;
import de.intarsys.tools.crypto.standard.SecretKeyParameter;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public class EncryptedByteProvider
implements IByteProvider {
    private IByteProvider inputProvider;
    private ICipherFactory cipherFactory;
    private IByteProvider keyProvider;
    private IByteProvider ivProvider;
    private byte[] currentIv;

    protected Cipher createEncipher() throws IOException, GeneralSecurityException {
        this.currentIv = this.getIvProvider().getBytes();
        byte[] currentKey = this.getKeyProvider().getBytes();
        SecretKeyParameter secret = new SecretKeyParameter(this.currentIv, currentKey);
        Cipher cipher = this.getCipherFactory().createEncipher(secret);
        return cipher;
    }

    @Override
    public byte[] getBytes() throws IOException {
        byte[] bytes = this.getInputProvider().getBytes();
        try {
            Cipher cipher = this.createEncipher();
            return cipher.doFinal(bytes);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public ICipherFactory getCipherFactory() {
        return this.cipherFactory;
    }

    public byte[] getCurrentIv() {
        return this.currentIv;
    }

    public IByteProvider getInputProvider() {
        return this.inputProvider;
    }

    public IByteProvider getIvProvider() {
        return this.ivProvider;
    }

    public IByteProvider getKeyProvider() {
        return this.keyProvider;
    }

    @PostConstruct
    public void init() {
        if (this.inputProvider == null) {
            throw new IllegalArgumentException("byteProvider required");
        }
        if (this.cipherFactory == null) {
            throw new IllegalArgumentException("cipherFactory required");
        }
        if (this.ivProvider == null) {
            throw new IllegalArgumentException("ivProvider required");
        }
        if (this.keyProvider == null) {
            throw new IllegalArgumentException("keyProvider required");
        }
    }

    public void setCipherFactory(ICipherFactory cipherFactory) {
        this.cipherFactory = cipherFactory;
    }

    public void setInputProvider(IByteProvider byteProvider) {
        this.inputProvider = byteProvider;
    }

    public void setIvProvider(IByteProvider ivProvider) {
        this.ivProvider = ivProvider;
    }

    public void setKeyProvider(IByteProvider keyProvider) {
        this.keyProvider = keyProvider;
    }
}

