/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.certificate.ITrustBase;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.TrustBaseTools;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.DefaultValidationTarget;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VSCertificatePath
extends CommonValidationState
implements IVSCertificatePath {
    private Map<IX509Certificate, IVSCertificate> certificateStates;
    private IX509Certificate trustAnchor;
    private String validationModel;
    private boolean chainingOk;

    public static IVSCertificatePath createInvalid(IMessage message) {
        VSCertificatePath state = new VSCertificatePath(null, 3);
        state.addMessage(ValidationMessage.createError(message));
        return state;
    }

    public static IVSCertificatePath createInvalid(String message) {
        VSCertificatePath state = new VSCertificatePath(null, 3);
        state.addMessage(ValidationMessage.createError(message));
        return state;
    }

    public VSCertificatePath(IVSCertificatePath state) {
        super(state);
    }

    public VSCertificatePath(IX509CertificatePath path) {
        super(new DefaultValidationTarget(path));
    }

    public VSCertificatePath(IX509CertificatePath path, int state) {
        super((IValidationTarget)new DefaultValidationTarget(path), state);
    }

    public void addCertificateState(IVSCertificate certificateState) {
        IValidationTarget target = certificateState.getValidationTarget();
        if (target == null) {
            return;
        }
        IX509Certificate certificate = (IX509Certificate)target.getImpl();
        this.basicGetCertificateStates().put(certificate, certificateState);
        this.increaseState(certificateState);
    }

    protected Map<IX509Certificate, IVSCertificate> basicGetCertificateStates() {
        if (this.certificateStates == null) {
            this.certificateStates = new LinkedHashMap<IX509Certificate, IVSCertificate>();
        }
        return this.certificateStates;
    }

    @Override
    protected void copy(IValidationState state) {
        super.copy(state);
        IVSCertificatePath pathState = (IVSCertificatePath)state;
        List<IVSCertificate> states = pathState.getCertificateStates();
        if (states != null) {
            for (IVSCertificate certState : states) {
                this.addCertificateState(certState);
            }
        }
        this.trustAnchor = pathState.getTrustAnchor();
        this.validationModel = pathState.getValidationModel();
        this.chainingOk = pathState.isChainingOk();
    }

    @Override
    public IVSCertificate getCertificateState(IX509Certificate certificate) {
        return this.basicGetCertificateStates().get(certificate);
    }

    @Override
    public List<IVSCertificate> getCertificateStates() {
        return new ArrayList<IVSCertificate>(this.basicGetCertificateStates().values());
    }

    @Override
    public IX509CertificatePath getCertPath() {
        if (this.getValidationTarget() == null) {
            return null;
        }
        return (IX509CertificatePath)this.getValidationTarget().getImpl();
    }

    @Override
    public IX509Certificate getTrustAnchor() {
        return this.trustAnchor;
    }

    @Override
    public ITrustBase getTrustBase() {
        IX509Certificate trustAnchor = this.getTrustAnchor();
        if (trustAnchor == null) {
            return null;
        }
        return TrustBaseTools.getTrustBase(trustAnchor);
    }

    @Override
    public String getValidationModel() {
        return this.validationModel;
    }

    @Override
    public boolean isChainingOk() {
        return this.chainingOk;
    }

    @Override
    public boolean isRecoverable() {
        if (!this.isUnknown()) {
            return false;
        }
        if (this.getTrustAnchor() == null) {
            return false;
        }
        for (IVSCertificate certificateState : this.getCertificateStates()) {
            if (this.isRecoverable(certificateState)) continue;
            return false;
        }
        return true;
    }

    public void setChainingOk(boolean chainingOk) {
        this.chainingOk = chainingOk;
    }

    public void setTrustAnchor(IX509Certificate trustedCert) {
        this.trustAnchor = trustedCert;
    }

    public void setValidationModel(String validationModel) {
        this.validationModel = validationModel;
    }

    @Override
    public void toString(PrettyPrinter printer) {
        super.toString(printer);
        printer.appendMember("certificateStates", this.getCertificateStates(), null);
    }
}

