/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.standard.validation.PACKAGE;
import de.intarsys.security.validation.IInfo;
import de.intarsys.security.validation.IInfoSet;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.IPrettyPrintable;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InfoSet
implements IInfoSet,
IPrettyPrintable {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private String title;
    private String titleLabel;
    private String textLabel;
    private List<IInfo> infos = new ArrayList<IInfo>();

    public InfoSet() {
    }

    public InfoSet(String pTitle) {
        this.title = pTitle;
    }

    public void addInfo(IInfo info) {
        this.infos.add(info);
    }

    public void addInfos(IInfoSet infoSet) {
        if (infoSet == null) {
            return;
        }
        for (IInfo info : infoSet) {
            this.addInfo(info);
        }
    }

    @Override
    public List<IInfo> getInfos() {
        return new ArrayList<IInfo>(this.infos);
    }

    @Override
    public String getTextLabel() {
        if (this.textLabel == null) {
            this.textLabel = Msg.getString("InfoSet.TextLabel", new Object[0]);
        }
        return this.textLabel;
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    @Override
    public String getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = Msg.getString("InfoSet.TitleLabel", new Object[0]);
        }
        return this.titleLabel;
    }

    @Override
    public Iterator<IInfo> iterator() {
        return this.infos.iterator();
    }

    public void setTextLabel(String pTextLabel) {
        this.textLabel = pTextLabel;
    }

    public void setTitle(String pTitle) {
        this.title = pTitle;
    }

    public void setTitleLabel(String pTitleLabel) {
        this.titleLabel = pTitleLabel;
    }

    @Override
    public int size() {
        return this.infos.size();
    }

    public void toString(PrettyPrinter printer) {
        if (this.title != null) {
            printer.appendMember("title", (Object)this.title, null);
        }
        if (this.titleLabel != null) {
            printer.appendMember("titleLabel", (Object)this.titleLabel, null);
        }
        if (this.textLabel != null) {
            printer.appendMember("textLabel", (Object)this.textLabel, null);
        }
        if (!this.infos.isEmpty()) {
            printer.appendMembers("infos", this.infos);
        }
    }
}

