/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.ssl;

import de.intarsys.security.ssl.TrustManagerChain;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.stream.Stream;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TrustManagerBuilder {
    private TrustManagerChain instance = new TrustManagerChain();

    public static TrustManagerBuilder get() {
        return new TrustManagerBuilder();
    }

    protected TrustManagerBuilder() {
    }

    public TrustManagerBuilder add(X509TrustManager trustManager) {
        this.instance.addTrustManager(trustManager);
        return this;
    }

    public TrustManagerBuilder addDefault() throws GeneralSecurityException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        TrustManager[] trustManagers = tmf.getTrustManagers();
        Stream.of(trustManagers).filter(tm -> tm instanceof X509TrustManager).map(tm -> (X509TrustManager)tm).forEach(this::add);
        return this;
    }

    public X509TrustManager build() {
        return this.instance;
    }
}

