/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.keystore;

import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.privatekey.PrivateKeyTools;
import de.intarsys.tools.authenticate.ConstantPasswordProvider;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.crypto.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;

public final class KeyStoreTools {
    public static KeyStore createJavaKeyStore(IX509PublicKeyCertificate certificate, Secret password) throws IOException, GeneralSecurityException {
        PrivateKey key = PrivateKeyTools.getPrivateKey(certificate, (IPasswordProvider)new ConstantPasswordProvider(password));
        if (key == null) {
            throw new UnrecoverableKeyException("key not found for " + CertificateTools.getSubjectLabel(certificate));
        }
        IX509Certificate[] certPath = ValidationTools.getCertificatePath(certificate);
        Certificate[] javaCerts = CertificateTools.toJavaCerts(certPath);
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null, null);
        keystore.setKeyEntry("1", key, password.getChars(), javaCerts);
        return keystore;
    }

    private KeyStoreTools() {
    }
}

