/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Extension;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.GeneralNames;

public class AuthorityKeyIdentifierHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("AuthorityKeyIdentifierHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.35";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        X500Principal[] p;
        ASN1Primitive value = CertificateTools.getExtensionValue(object, this.getOID());
        AuthorityKeyIdentifier id = AuthorityKeyIdentifier.getInstance((Object)value);
        if (id == null) {
            return null;
        }
        GeneralNames issuer = id.getAuthorityCertIssuer();
        BigInteger serial = id.getAuthorityCertSerialNumber();
        byte[] keyId = id.getKeyIdentifier();
        StringBuilder sb = new StringBuilder();
        if (issuer != null && (p = CertificateTools.parsePrincipals(issuer)) != null) {
            for (int i = 0; i < p.length; ++i) {
                X500Principal principal = p[i];
                sb.append("AuthorityCertIssuer: ").append(principal.toString()).append(StringTools.LS);
            }
        }
        if (serial != null) {
            sb.append("AuthorityCertSerialNumber: ").append(serial.toString()).append(StringTools.LS);
        }
        if (keyId != null) {
            sb.append("KeyIdentifier: #").append(HexTools.bytesToHexString((byte[])keyId)).append(StringTools.LS);
        }
        return sb.toString();
    }
}

