/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.IX509CRLSelector;
import de.intarsys.tools.function.OnError;
import de.intarsys.tools.streaming.StreamingTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeCRLProvider
implements ICRLProvider {
    private static final Logger Log = LoggerFactory.getLogger(CompositeCRLProvider.class);
    private List<ICRLProvider> delegateProviders = new ArrayList<ICRLProvider>();

    public CompositeCRLProvider() {
        this.delegateProviders = new ArrayList<ICRLProvider>();
    }

    public CompositeCRLProvider(Collection<ICRLProvider> delegateProviders) {
        this.delegateProviders = new ArrayList<ICRLProvider>(delegateProviders);
    }

    public void addDelegateProvider(ICRLProvider delegate) {
        this.delegateProviders.add(delegate);
    }

    protected Stream<IX509CRL> basicLookupCRLs(IX509CRLSelector selector, String url) throws IOException {
        return Stream.empty();
    }

    public List<ICRLProvider> getDelegateProviders() {
        return new ArrayList<ICRLProvider>(this.delegateProviders);
    }

    @Override
    public Stream<IX509CRL> lookupCRLs(IX509CRLSelector selector, String url) throws IOException {
        Stream result = this.basicLookupCRLs(selector, url);
        result = StreamingTools.concatIfEmpty(result, () -> this.getDelegateProviders().stream().flatMap(OnError.log(provider -> provider.lookupCRLs(selector, url), (Logger)Log, () -> Stream.empty())));
        return result;
    }
}

