/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.CertificateSet;
import de.intarsys.asn1.cms.ContentType;
import de.intarsys.asn1.cms.EncapsulatedContentInfo;
import de.intarsys.asn1.cms.IssuerAndSerialNumber;
import de.intarsys.asn1.cms.RevocationInfoChoices;
import de.intarsys.asn1.cms.SignedAttributes;
import de.intarsys.asn1.cms.SignerIdentifier;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.UnsignedAttributes;
import de.intarsys.asn1.cms.attr.AttributeContentType;
import de.intarsys.asn1.cms.attr.AttributeMessageDigest;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.SubjectKeyIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.x509.Certificate;
import de.intarsys.asn1.x509.CertificateSerialNumber;
import de.intarsys.asn1.x509.Name;
import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.AlgorithmTools;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.CertificateProvider;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.method.cms.signature.RevocationInfos;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IExtendedValidationDataSupport;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSSignature
implements IExtendedValidationDataSupport {
    private static final Logger Log = LoggerFactory.getLogger(CMSSignature.class);
    private IX509PublicKeyCertificate[] certificates;
    private final CMS cms;
    private byte[] pkcs7Bytes;
    private IExtendedValidationData extendedValidationData = new IExtendedValidationData(){

        public Stream<IX509PublicKeyCertificate> getCertificates() {
            try {
                return Arrays.stream(CMSSignature.this.getCertificates());
            }
            catch (IOException | CertificateException e) {
                Log.warn(e.getMessage(), (Throwable)e);
                return Stream.empty();
            }
        }

        public Stream<IX509CRL> getCRLs() {
            try {
                return Arrays.stream(CMSSignature.this.getRevocationInfos().getCRLs());
            }
            catch (IOException e) {
                Log.warn(e.getMessage(), (Throwable)e);
                return Stream.empty();
            }
        }

        public Stream<IOCSPResponse> getOCSPResponses() {
            try {
                return Arrays.stream(CMSSignature.this.getRevocationInfos().getOCSPResponses());
            }
            catch (IOException e) {
                Log.warn(e.getMessage(), (Throwable)e);
                return Stream.empty();
            }
        }
    };

    public CMSSignature(byte[] pkcs7Bytes) throws IOException {
        assert (pkcs7Bytes != null);
        this.pkcs7Bytes = pkcs7Bytes;
        this.cms = (CMS)ASN1BasedTools.create((ASN1Based.Factory)CMS.FACTORY, (byte[])pkcs7Bytes);
    }

    public CMSSignature(CMS cms) {
        assert (cms != null);
        this.cms = cms;
    }

    protected IX509CertificateFilter createCertificateSelector(SignerIdentifier sid) throws IOException {
        IssuerAndSerialNumber issuerAndSerialNumber = sid.getIssuerAndSerialNumber();
        if (issuerAndSerialNumber != null) {
            X509CertificateSelector selector = new X509CertificateSelector();
            Name issuer = issuerAndSerialNumber.getIssuer();
            CertificateSerialNumber serialNumber = issuerAndSerialNumber.getSerialNumber();
            if (issuer == null || serialNumber == null) {
                return null;
            }
            selector.setIssuer(issuerAndSerialNumber.getIssuer().getDEREncoded());
            selector.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            return selector;
        }
        SubjectKeyIdentifier subjectKeyIdentifier = sid.getSubjectKeyIdentifier();
        if (subjectKeyIdentifier != null) {
            X509CertificateSelector selector = new X509CertificateSelector();
            selector.setSubjectKeyIdentifier(subjectKeyIdentifier.getDEREncoded());
            return selector;
        }
        return null;
    }

    public IDigest getAttrMessageDigest(int signerInfoId) {
        AttributeMessageDigest amd;
        SignerInfo signerInfo = this.getSignerInfo(signerInfoId);
        SignedAttributes signedAttrs = signerInfo.getSignedAttrs();
        if (signedAttrs != null && (amd = signedAttrs.getMessageDigestAttribut()) != null) {
            DigestAlgorithm algorithm = this.getHashAlgorithm(signerInfoId);
            return DigestTools.createDigest((String)algorithm.getCanonicalName(), (byte[])amd.getMessageDigest());
        }
        return null;
    }

    public byte[] getBytes() {
        if (this.pkcs7Bytes == null) {
            try {
                return this.getCMS().getDEREncoded();
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.pkcs7Bytes;
    }

    public IX509PublicKeyCertificate[] getCertificates() throws CertificateException, IOException {
        if (this.certificates != null) {
            return this.certificates;
        }
        ArrayList<IX509PublicKeyCertificate> result = new ArrayList<IX509PublicKeyCertificate>();
        CertificateSet certificateSet = this.getCMS().getSignedData().getCertificates();
        if (certificateSet == null) {
            this.certificates = new IX509PublicKeyCertificate[0];
        } else {
            for (int i = 0; i < certificateSet.size(); ++i) {
                Certificate cert = certificateSet.get(i);
                if (cert == null) continue;
                result.add(this.toX509Cert(cert));
            }
            this.certificates = result.toArray(new IX509PublicKeyCertificate[result.size()]);
        }
        return this.certificates;
    }

    public CMS getCMS() {
        return this.cms;
    }

    public String getContentType(int signerInfoId) {
        SignedAttributes sa = this.getSignerInfo(signerInfoId).getSignedAttrs();
        if (sa == null) {
            return null;
        }
        AttributeContentType attrs = sa.getContentType();
        if (attrs == null) {
            return null;
        }
        ContentType contentType = attrs.getContentType();
        if (contentType == null) {
            return null;
        }
        return contentType.getIdentifier();
    }

    public IDigester getDigester(int signerInfoId) throws NoSuchAlgorithmException {
        AlgorithmSpec<DigestAlgorithm> algorithmSpec = this.getHashAlgorithmSpec(signerInfoId);
        if (algorithmSpec == null) {
            throw new NoSuchAlgorithmException(this.getHashAlgorithmOID(signerInfoId));
        }
        return DigestTools.createDigester((String)algorithmSpec.getAlgorithm().getCanonicalName());
    }

    public IExtendedValidationData getExtendedValidationData() {
        return this.extendedValidationData;
    }

    @Deprecated
    public DigestAlgorithm getHashAlgorithm(int signerInfoId) {
        String algOID = this.getHashAlgorithmOID(signerInfoId);
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)algOID);
        if (algorithm == null) {
            String hashAlgorithmName = SignatureAlgorithm.getHashAlgorithmName((String)algOID);
            algorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)hashAlgorithmName);
        }
        return algorithm;
    }

    public String getHashAlgorithmOID(int signerInfoId) {
        SignerInfo signerInfo = this.getSignerInfo(signerInfoId);
        return signerInfo.getDigestAlgorithm().getAlgorithm();
    }

    public AlgorithmSpec<DigestAlgorithm> getHashAlgorithmSpec(int signerInfoId) {
        String algOID = this.getHashAlgorithmOID(signerInfoId);
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)algOID);
        if (algorithm == null) {
            String hashAlgorithmName = SignatureAlgorithm.getHashAlgorithmName((String)algOID);
            algorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)hashAlgorithmName);
        }
        if (algorithm == null) {
            return null;
        }
        return new AlgorithmSpec((Algorithm)algorithm);
    }

    public IDigest getMessageDigest(SignerInfo signerInfo) {
        SignedAttributes signedAttrs = signerInfo.getSignedAttrs();
        AttributeMessageDigest amd = signedAttrs.getMessageDigestAttribut();
        if (amd == null) {
            return null;
        }
        String algOID = signerInfo.getDigestAlgorithm().getAlgorithm();
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)algOID);
        return DigestTools.createDigest((String)algorithm.getName(), (byte[])amd.getMessageDigest());
    }

    public RevocationInfos getRevocationInfos() {
        RevocationInfoChoices choices = this.getCMS().getSignedData().getCrls();
        return new RevocationInfos(choices);
    }

    public String getSignatureAlgorithmOID(int signerInfoId) {
        SignerInfo signerInfo = this.getSignerInfo(signerInfoId);
        return signerInfo.getSignatureAlgorithm().getAlgorithm();
    }

    public AlgorithmSpec<SignatureAlgorithm> getSignatureAlgorithmSpec(int signerInfoId) {
        String algOID = this.getSignatureAlgorithmOID(signerInfoId);
        SignatureAlgorithm algorithm = SignatureAlgorithm.lookupAlgorithm((String)algOID);
        if (algorithm == null) {
            return null;
        }
        return new AlgorithmSpec((Algorithm)algorithm);
    }

    public byte[] getSignatureBytes(int signerInfoId) {
        SignerInfo signerInfo = this.getSignerInfo(signerInfoId);
        byte[] pkcs1 = signerInfo.getSignature().getBytes();
        return pkcs1;
    }

    public SignedAttributes getSignedAttributes(int signerInfoId) {
        return this.getSignerInfo(signerInfoId).getSignedAttrs();
    }

    public IDigester getSignedAttributesDigester(int signerInfoId) throws GeneralSecurityException, IOException {
        AlgorithmIdentifier signatureAlgId = this.getSignerInfo(signerInfoId).getSignatureAlgorithm();
        if ("1.2.840.113549.1.1.10".equals(signatureAlgId.getAlgorithm())) {
            PSSParameterSpec pssParams = (PSSParameterSpec)AlgorithmTools.toAlgorithmParameterSpec((byte[])signatureAlgId.getParametersEncoded(), (String)"PSS", PSSParameterSpec.class);
            if (pssParams == null) {
                throw new NoSuchAlgorithmException("RSASSA-PSS without algorithm parameters");
            }
            DigestAlgorithm hashAlgorithm = DigestAlgorithm.lookupAlgorithm((String)pssParams.getDigestAlgorithm());
            return DigestTools.createDigester((String)hashAlgorithm.getCanonicalName());
        }
        return this.getDigester(signerInfoId);
    }

    public byte[] getSignedContent() {
        EncapsulatedContentInfo contentInfo = this.getCMS().getSignedData().getEncapContentInfo();
        return contentInfo.getContentBytes();
    }

    public IX509PublicKeyCertificate getSignerCertificate(int signerInfoId) throws CertificateException, IOException {
        Iterator iSignerCertificate;
        IX509CertificateFilter signerSelector;
        SignerIdentifier sid = this.getSignerInfo(signerInfoId).getSid();
        CertificateSet certificateSet = this.getCMS().getSignedData().getCertificates();
        if (certificateSet != null) {
            try {
                Certificate cert = certificateSet.getCertificate(sid);
                if (cert != null) {
                    return this.toX509Cert(cert);
                }
            }
            catch (IllegalArgumentException e) {
                throw new CertificateException("error parsing certificate");
            }
        }
        if ((signerSelector = this.createCertificateSelector(sid)) != null && (iSignerCertificate = CertificateProvider.get().lookupCertificates(signerSelector)).hasNext()) {
            return (IX509PublicKeyCertificate)iSignerCertificate.next();
        }
        return null;
    }

    public SignerInfo getSignerInfo(int index) {
        return this.getCMS().getSignedData().getSignerInfos().get(index);
    }

    public int getSignerInfosSize() {
        return this.getCMS().getSignedData().getSignerInfos().size();
    }

    public UnsignedAttributes getUnsignedAttributes(int signerInfoId) {
        return this.getSignerInfo(signerInfoId).getUnsignedAttrs();
    }

    public boolean hasSignedContent() {
        return this.getSignedContent() != null;
    }

    private IX509PublicKeyCertificate toX509Cert(Certificate cert) throws IOException, CertificateException {
        return X509CertificateFactory.get().createPublicKeyCertificate(cert.getDEREncoded());
    }
}

